#include "BSprivate.h"
    
/*@ BSmain_reperm - Permute the sparse matrix using data structures
                    generated by BSmain_perm on the same matrix structure

    Input Parameters:
.   procinfo - the usual processor information
.   A - the original sparse matrix
.   pA - the matrix generated by an execution of BSmain_perm

    Output Parameters:
.   pA - same as pA except that the nonzero values in pA are the same
         as those in A

    Returns:
    void

    Notes:
    The matrix pA must have been generated by BSmain_perm with
    retain set to TRUE.

 @*/
void BSmain_reperm(procinfo,A,pA)
BSprocinfo	*procinfo;
BSspmat	*A;
BSpar_mat	*pA;
{
    BSreperm *reperm;
	BSsprow **perm_rows;
	int	max_row_len;

	reperm = pA->reperm;

	/* check to make sure that reperm isn't NULL */
	if (reperm == NULL) {
		MY_SETERRC(REPERM_ERROR,
			"Permutation information not saved: cannot repermute matrix\n");
	}

	/* check rows for consistency */
	if (procinfo->error_check) {
		BSrow_err_check(A,procinfo); CHKERR(0);
	}

	/* *************************************************************** */
	/* BEGIN SECTION:                                                  */
	/* Permute the nonzeros at the row level and sort them             */
	/* Remember to unsort them                                         */
	/* *************************************************************** */

	BSperm_rows(A,pA->global_row_num,reperm->inode_perm,
		reperm->inode_distr,procinfo,FALSE,&max_row_len); CHKERR(0);
	perm_rows = BSrow_perm(A,pA->inv_perm); CHKERR(0);

	/* *************************************************************** */
	/* END SECTION:                                                    */
	/* *************************************************************** */

	/* *************************************************************** */
	/* BEGIN SECTION:                                                  */
	/* Put the numeric values into the transposed inode structure      */
	/* *************************************************************** */
	BSnz_2_inode(A,perm_rows,pA->inodes,pA->clique2inode,procinfo); CHKERR(0);
	MY_FREE(perm_rows);

	/* *************************************************************** */
	/* END SECTION:                                                    */
	/* *************************************************************** */

	/* *************************************************************** */
	/* BEGIN SECTION:                                                  */
	/* Unsort the rows to original condition                           */
	/* *************************************************************** */

	BSsort_rows(A,reperm->inode_perm,reperm->inode_distr,max_row_len); 
	CHKERR(0);

	/* *************************************************************** */
	/* END SECTION:                                                    */
	/* *************************************************************** */

	/* get the diagonal */
	BSget_diag(pA,pA->diag,procinfo); CHKERR(0);
	pA->map = A->map;
}
