#include "BSprivate.h"

/*+ BSlow2high - A translation from a higher level matrix to a lower level
                 matrix

    Input Parameters:
.   A - the sparse matrix (low level)
.   number - the high level numbering
.   distr - the high level distribution
.   procinfo - the usual processor information

    Returns:
    A numbering of length len(distr)+1 translating from high to low

	Notes:
    For example, this routine is used to find the global row number for
    the first row in each i-node.

 +*/
BSnumbering *BSlow2high(A,number,distr,procinfo)
BSspmat *A;
BSnumbering *number;
BSdistribution *distr;
BSprocinfo *procinfo;
{
	int	i;
	int	ind;
	BSnumbering *l2h;

	l2h = BSalloc_numbering(distr->max+1); CHKERRN(0);

	for (i=0;i<distr->max+1;i++) l2h->numbers[i] = -1;
	for (i=0;i<number->length;i++) {
		ind = number->numbers[i];
		if (l2h->numbers[ind] < 0) {
			(*A->map->flocal2global)(1,&i,&(l2h->numbers[ind]),procinfo,A->map);
			CHKERRN(0);
		}
	}
	return(l2h);
}
