#include "BSprivate.h"

/*@ BSinv_diag_block - Invert the dense diagonal blocks of the matrix

    Input Parameters:
.   A - the sparse matrix
.   procinfo - the usual processor information

    Output Parameters:
.   A - the sparse matrix with inverted blocks

    Returns:
    void

 @*/
void BSinv_diag_block(A,procinfo)
BSpar_mat *A;
BSprocinfo *procinfo;
{
	FLOAT	*matrix;
	int	cl_ind, size;
	BScl_2_inode *cliques;
	char UP = 'U';
	char DI = 'N';
	int	info;

	cliques = A->clique2inode;
	for (cl_ind=0;cl_ind<cliques->num_cols;cl_ind++) {
		if (cliques->proc[cl_ind] == procinfo->my_id) {
			matrix = cliques->d_mats[cl_ind].matrix;
			size = cliques->d_mats[cl_ind].size;
			DTRTRI(&UP,&DI,&size,matrix,&size,&info);
		}
	}
}
