#include	"BSprivate.h"

/*+ BSins_diag - insert diagonals back into matrix

    Input Parameters:
.   A - the sparse matrix

    Output Parameters:
.   A - the sparse matrix with diagonals

    Returns:
    void

    Notes:
    This routine only works if BSrem_diag has previously removed the diagonal.
    It relies on the array being preallocated and the diagonal value
    being hidden at the end of the array

+*/
void	BSins_diag(A)
BSspmat *A;
{
	int	i, j;
	BSsprow *row;
	int	ival;

	for (i=0;i<A->num_rows;i++) {
		row = A->rows[i];
		row->diag_ind = -row->diag_ind;
		row->length++;
		ival = row->col[row->length-1];
		for (j=row->length-1;j>row->diag_ind;j--) {
			row->col[j] = row->col[j-1];
		}
		row->col[row->diag_ind] = ival;
	}
}
