#include "BSprivate.h"

/*+ BSido_color - Do a local IDO coloring

	Input Parameters: 
.   ido_queue - the nodes to color
.   n_queue - the length of the ido_queue
.   A - the sparse matrix
.   local_color - the local coloring
.   global_color - the colors of global nodes adjacent to each processor
.   local_ptr - array of pointers indicating which neighbors in
.               each row are local neighbors (on this processor)
.   global_ptr - array of pointers indicating which neighbors in
.                each row are global neighbors (not on this processor)
.   color_template - used to figure out what colors are around a node
.   ido_degree - the ido degree of each node
.   ido_queue_ptr - a work vector (should be 0's)
.   ido_deg_ptr - a work vector
.   procinfo - the usual processor info

	Output Parameters: 
.   ido_degree - the updated ido degree of nodes
+*/
void BSido_color(ido_queue,n_queue,A,local_color,global_color,local_ptr,
	global_ptr,color_template,ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo)
int	*ido_queue;	
int	n_queue;
BSspmat *A;
int	*local_color;
int	**global_color;
int	*local_ptr;
int	*global_ptr;
int	*color_template;
int	*ido_degree;
int	*ido_queue_ptr;
int	*ido_deg_ptr;
BSprocinfo *procinfo;
{
	BSsprow	**local_col_array;
	int	*row_ptr;
	BSsprow	*t_node;
	int i, j;
	int max_ido_deg, deg, l_vtx, t_color;
	int p1, p2, v1, v2;

	local_col_array = A->rows;

	/* Get ido_degrees and store as key in ido_queue_ptr */

	ido_queue_ptr[0] = 0;
	for (i=0; i<n_queue; i++)
	{
		l_vtx = ido_queue[i];
		ido_queue_ptr[i] = ido_degree[l_vtx];
	}

	/* Sort ido_queue by ido_degree; sorts both ido_queue_ptr & ido_queue */

	BSheap_sorthl1(n_queue,ido_queue_ptr,ido_queue); CHKERR(0);

	/* Construct ido_deg_ptrs for ido_queue */

	max_ido_deg = ido_queue_ptr[0];
	ido_queue_ptr[0] = 0;
	deg = max_ido_deg;
	for (i=1; i<n_queue; i++) {
		while (ido_queue_ptr[i] != deg) {
			ido_deg_ptr[deg] = i-1;
			deg--;
		}
		ido_queue_ptr[i] = 0;
	}
	ido_deg_ptr[deg] = n_queue - 1;

	/* Construct ido_queue_ptrs */

	for (i=0; i<n_queue; i++) {
		l_vtx = ido_queue[i];
		ido_queue_ptr[l_vtx] = i;
	}

	/* Main loop */

	for (i=0; i<n_queue; i++) {
		l_vtx = ido_queue[i];
		t_node = local_col_array[l_vtx];
		row_ptr = t_node->col;

		/* Check global adjacent nodes & mark unusable colors */

		for (j=0; j<global_ptr[l_vtx]; j++) {
			t_color = global_color[l_vtx][j];
			color_template[t_color] = l_vtx;
		}

		/* Check local nodes and update their degree or mark unusable colors */
			
		for (j=local_ptr[l_vtx]; j<t_node->length; j++) {
			(*A->map->fglobal2local)
				(1,&(row_ptr[j]),&v1,procinfo,A->map);CHKERR(0);
			if (v1 < 0) {
				MY_SETERRC(COLOR_ERROR,"Bad global to local translation\n");
			}
			t_color = local_color[v1];
			if (t_color == NO_COLOR) {
				ido_degree[v1]++;
				p1 = ido_queue_ptr[v1];
				if(p1 > i) {
					if (ido_degree[v1] > max_ido_deg) {
						max_ido_deg = ido_degree[v1];
						p2 = i+1;
						ido_deg_ptr[max_ido_deg] = p2;
					}
					else {
						ido_deg_ptr[ido_degree[v1]]++;
						p2 = ido_deg_ptr[ido_degree[v1]];
					}
					if (p1 != p2) {
						v2 = ido_queue[p2];
						ido_queue[p1] = v2;
						ido_queue[p2] = v1;
						ido_queue_ptr[v1] = p2;
						ido_queue_ptr[v2] = p1;
					}
				}
			}
			else 
			{
				color_template[t_color] = l_vtx;
			}
		}
		while ((ido_deg_ptr[max_ido_deg] == i) && (max_ido_deg > 0)) max_ido_deg--;

		/* Choose t_color */

		t_color = 0;
		while (color_template[t_color] == l_vtx) 
			t_color++;
		local_color[l_vtx] = t_color;
	}

	/* Clean up ido_queue_ptr */

	for (i=0; i<n_queue; i++)
	{
		l_vtx = ido_queue[i];
		ido_queue_ptr[l_vtx] = 0;
	}

}
