#include "BSprivate.h"

/*+ BSglobal_perm - Find a permutation based on a numbering

    Input Parameters:
.   numbering - the numbering to find a permutation for

    Returns:
    the permutation that will put the numbering into sorted order

+*/
BSpermutation *BSglobal_perm(numbering)
BSnumbering *numbering;
{
	BSpermutation *perm, *iperm;
	int	i;

	perm = BSalloc_permutation(numbering->length); CHKERRN(0);
	iperm = BSalloc_permutation(numbering->length); CHKERRN(0);
	for (i=0;i<numbering->length;i++) {
		iperm->perm[i] = i;
		perm->perm[i] = numbering->numbers[i];
	}
	BSheap_sort1(perm->length,perm->perm,iperm->perm); CHKERRN(0);
	BSperm2iperm(iperm,perm); CHKERRN(0);
	BSfree_permutation(iperm); CHKERRN(0);

	return(perm);
}
