#include "BSprivate.h"

/*@ BSget_diag - Retrieve the diagonal of the matrix

    Input Parameters:
.   A - The sparse matrix
.   procinfo - the usual processor info

    Output Parameters:
.   diag - The vector containing the diagonal

    Returns:
    void

    Notes:
    Find the diagonal in the dense matrices associated with the cliques.

 @*/

void BSget_diag(A,diag,procinfo)
BSpar_mat *A;
FLOAT	*diag;
BSprocinfo *procinfo;
{
	int	count;
	int	i;
	FLOAT	*matrix;
	int	cl_ind, size;
	BScl_2_inode *cliques;

	count = 0;
	cliques = A->clique2inode;
	for (cl_ind=0;cl_ind<cliques->num_cols;cl_ind++) {
		if (cliques->proc[cl_ind] == procinfo->my_id) {
			matrix = cliques->d_mats[cl_ind].matrix;
			size = cliques->d_mats[cl_ind].size;
			for (i=0;i<size;i++) {
				diag[count] = matrix[(i*size)+i];
				count++;
			}
		}
	}
}
