#include "BSprivate.h"

/*@ BSfree_par_mat - Free a sparse matrix (parallel format)

    Input Parameters:
.   A - The sparse matrix to be freed

    Returns:
    void

 @*/
void BSfree_par_mat(A)
BSpar_mat *A;
{
	BSfree_permutation(A->perm); CHKERR(0);
	BSfree_permutation(A->inv_perm); CHKERR(0);
	BSfree_numbering(A->global_row_num); CHKERR(0);
	BSfree_numbering(A->color2clique); CHKERR(0);
	BSfree_cl_2_inode(A->clique2inode,TRUE); CHKERR(0);
	BSfree_inode_list(A->inodes); CHKERR(0);
	if ((A->save_diag != NULL) && (A->save_diag != A->diag)) {
		MY_FREE(A->save_diag);
	}
	if ((A->scale_diag != NULL) && (A->scale_diag != A->diag)) {
		MY_FREE(A->scale_diag);
	}
	MY_FREE(A->diag);
	if (A->reperm != NULL) {
		BSfree_reperm(A->reperm);
		CHKERR(0);
	}
	MY_FREE(A);
}

/*@ BSfree_copy_par_mat - Free a copy of a sparse matrix (parallel format)

    Input Parameters:
.   A - The sparse matrix to be freed

    Returns:
    void

    Notes: Only those portions that are copies (and not pointers) 
           are freed.
 @*/
void BSfree_copy_par_mat(A)
BSpar_mat *A;
{
	BSfree_cl_2_inode(A->clique2inode,FALSE); CHKERR(0);
	BSfree_inode_list(A->inodes); CHKERR(0);
	MY_FREE(A);
}
