#include "BSprivate.h"

/*@ BSfree_easymat - Free a sparse matrix allocated in BSeasy_mat

    Input Parameters:
.   A - The sparse matrix

    Returns:
    void

 @*/
void BSfree_easymat(A)
BSspmat *A;
{
	int	i;

	for (i=0;i<A->num_rows;i++) {
		MY_FREE(A->rows[i]);
	}
	if (A->map != NULL) {
		if (A->map->free_l2g != NULL) {
			(*A->map->free_l2g)(A->map->vlocal2global); CHKERR(0);
		}
		if (A->map->free_g2l != NULL) {
			(*A->map->free_g2l)(A->map->vglobal2local); CHKERR(0);
		}
		if (A->map->free_g2p != NULL) {
			(*A->map->free_g2p)(A->map->vglobal2proc); CHKERR(0);
		}
		MY_FREE(A->map);
	}
	MY_FREE(A->rows);
	MY_FREE(A);
}
