#include "BSprivate.h"

/*+ BSfree_comm_data - Free data from the communication compilation

    Input Parameters:
.   data - the data to be freed

    Returns:
    void

+*/
void BSfree_comm_data(data)
int	*data;
{
	MY_FREE(data);
}

/*@ BSfree_comm - Free the compiled communication pattern

    Input Parameters:
.   comm_ptr - the structure to be freed

    Returns:
    void

@*/
void BSfree_comm(comm_ptr)
BScomm *comm_ptr;
{
	BMfree_comp_msg(comm_ptr->from_msg); CHKERR(0);
	BMfree_comp_msg(comm_ptr->to_msg); CHKERR(0);
	MY_FREE(comm_ptr);
}
