#include "BSprivate.h"

/*+ BSfree_cl_2_inode - Free the BScl_2_inode structure

    Input Parameters:
.   cl_data - the data structure to free
.   original - TRUE if this is the original structure, FALSE
               if it is a copy

    Returns:
    void

    Notes:
    This only frees part of the stucture if it is a copy

+*/
void BSfree_cl_2_inode(cl_data,original)
BScl_2_inode *cl_data;
int	original;
{
	int	i;

	MY_FREE(cl_data->g_offset);
	MY_FREE(cl_data->proc);
	MY_FREE(cl_data->inode_index);
	for (i=0;i<cl_data->num_cols;i++) {
		if ((cl_data->d_mats[i].matrix != NULL) && (original)) 
			MY_FREE(cl_data->d_mats[i].matrix);
	}
	MY_FREE(cl_data->d_mats);
	MY_FREE(cl_data);
}
