#include	"BSprivate.h"

/*+ BSfold_distr - Fold one the distribution from level into another

    Input Parameters:
.   clique_1_distr - The distribution to be folded into (outer level)
.   inode_distr - the distribution being folded
.   clique_numbering - the numbering of the nodes in the lower level
                       distribution

    Returns:
    the folded distribution

    Notes:
    For example, if one wants to know the number of columns in a
    clique, then one folds the <distribution of columns in the
    inodes> into the <distribution of i-nodes in the cliques>.  This
    may not make much sense and isn't all that important.

+*/
BSdistribution *BSfold_distr(clique_1_distr,inode_distr,clique_numbering)
BSdistribution *clique_1_distr;
BSdistribution *inode_distr;
BSnumbering *clique_numbering;
{
	BSdistribution *clique_2_distr;
	int	i;

	clique_2_distr = BSalloc_distribution(clique_1_distr->max); CHKERRN(0);
	for (i=0;i<=clique_2_distr->max;i++) clique_2_distr->distribution[i] = 0;
	for (i=0;i<clique_numbering->length;i++) {
		(clique_2_distr->distribution[clique_numbering->numbers[i]]) += 
			(inode_distr->distribution[i]);
	}
	return(clique_2_distr);
}
