#include "BSprivate.h"

/*@ BSfactor - Compute the incomplete factor of a matrix

    Input Parameters:
.   A - The sparse matrix to be factored
.   comm - the communication structure of the factoring
.   procinfo - the usual processor info

    Output Parameters:
.   A - The factored sparse matrix

    Returns:
    0 if successful, otherwise a negative number whose absolute
    value is the row number of the color (less one) where the
    failure occured.

 @*/
int BSfactor(A,comm,procinfo)
BSpar_mat *A;
BScomm *comm;
BSprocinfo *procinfo;
{
	if (procinfo->single) {
		return(BSfactor1(A,comm,procinfo));
	} else {
		return(BSfactorn(A,comm,procinfo));
	}
}
