#include "BSprivate.h"

/*@ BScopy_nz - Copy the nonzero values from one matrix to another

    Input Parameters:
.   A - The source matrix

    Output Parameters:
.   newA - The destination matrix

    Returns:
    void

    Notes: Recall that A and another matrix are symmetric and generally
           share the square dense matrices (with the assumption that
           the diagonal of one matrix is either known or stored elsewhere)
           associated with the cliques.

 @*/
void BScopy_nz(A,newA)
BSpar_mat *A;
BSpar_mat *newA;
{
	int	i, j, k;
	int	size, len;
	FLOAT	*matrix;
	BSinode *inodes, *new_inodes;

	/* first copy the clique blocks */
	/* we now that both matrices point to the same blocks and */
	/* that A is stored in the lower triangle and newA in the upper */
	BScopy_cliques(A); CHKERR(0);

	/* now copy the inodes */
	inodes = A->inodes->list;
	len = A->inodes->length;
	new_inodes = newA->inodes->list;
	for (i=0;i<len;i++) {
		size = inodes[i].length;
		for (j=0;j<inodes[i].num_cols;j++) {
			for (k=0;k<size;k++) {
				new_inodes[i].nz[(j*size)+k] = inodes[i].nz[(j*size)+k];
			}
		}
	}
}

/*+ BScopy_cliques - Copy the nonzero values from the cliques of
                     one matrix to another

    Input Parameters:
.   A - The source matrix

    Output Parameters:
.   A - The destination matrix

    Returns:
    void

    Notes: Recall that A and another matrix are symmetric and generally
           share the square dense matrices (with the assumption that
           the diagonal of one matrix is either known or stored elsewhere)
           associated with the cliques.

+*/
void BScopy_cliques(A)
BSpar_mat *A;
{
	int	i, j, k;
	int	size, len;
	BScl_2_inode *cl2i;
	FLOAT	*matrix;

	/* copy from the upper triangle to the lower triangle of the cliques */
	/* that A is stored in the lower triangle and newA in the upper */
	cl2i = A->clique2inode;
	for (i=0;i<cl2i->num_cols;i++) {
		matrix = cl2i->d_mats[i].matrix;
		size = cl2i->d_mats[i].size;
		for (j=0;j<size;j++) {
			for (k=0;k<j;k++) {
				matrix[(j*size)+k] = matrix[(k*size)+j];
			}
		}
	}
}
