#include	"BSprivate.h"

/*@ BScreate_ctx - Create the execution time context for the package

	Input Parameters: 
.   none

    Returns:
    The allocated context

 @*/
BSprocinfo	*BScreate_ctx()
{
	BSprocinfo	*procinfo;

	MY_MALLOCN(procinfo,(BSprocinfo *),sizeof(BSprocinfo),1);
	BSctx_set_id(procinfo,MYPROCID);
	BSctx_set_np(procinfo,NUMNODES);
	BSctx_set_ps(procinfo,NULL);
	BSctx_set_cs(procinfo,INT_MAX);
	BSctx_set_is(procinfo,INT_MAX);
	BSctx_set_ct(procinfo,IDO);
	BSctx_set_err(procinfo,FALSE);
	BSctx_set_rt(procinfo,FALSE);
	BSctx_set_pr(procinfo,FALSE);
	BSctx_set_si(procinfo,FALSE);
	return(procinfo);
}

/*@ BSfree_ctx - Free the context

	Input Parameters: 
.   context - The structure to be freed

    Returns:
    void

 @*/
void	BSfree_ctx(context)
BSprocinfo	*context;
{
	MY_FREE(context);
}

/*@ BSctx_set_id - Set the processor id

	Input Parameters: 
.   context - The context to change
.   id - The processor id

    Returns:
    void

 @*/
void	BSctx_set_id(context,id)
BSprocinfo	*context;
int	id;
{
	context->my_id = id;
}

/*@ BSctx_set_np - Set the number of processors

	Input Parameters: 
.   context - The context to change
.   np - The number of processors

    Returns:
    void

 @*/
void	BSctx_set_np(context,np)
BSprocinfo	*context;
int	np;
{
	context->nprocs = np;
}


/*@ BSctx_set_ps - Set the processor set

	Input Parameters: 
.   context - The context to change
.   set - The processor set

    Returns:
    void

 @*/
void	BSctx_set_ps(context,ps)
BSprocinfo	*context;
ProcSet	*ps;
{
	context->procset = ps;
}

/*@ BSctx_set_cs - Set the maximum clique size allowed

	Input Parameters: 
.   context - The context to change
.   cs - The maximum clique size

    Returns:
    void

 @*/
void	BSctx_set_cs(context,cs)
BSprocinfo	*context;
int	cs;
{
	context->max_clique_size = cs;
}

/*@ BSctx_set_is - Set the maximum i-node size allowed

	Input Parameters: 
.   context - The context to change
.   is - The maximum i-node size

    Returns:
    void

 @*/
void	BSctx_set_is(context,is)
BSprocinfo	*context;
int	is;
{
	context->max_inode_size = is;
}

/*@ BSctx_set_ct - Set the type of coloring

	Input Parameters: 
.   context - The context to change
.   coloring - IDO (incident degree ordering) or
.              SDO (saturated degree ordering)

    Returns:
    void

    Notes:
    This is only the local coloring, the global coloring
    uses the Jones/Plassmann parallel algorithm
 @*/
void	BSctx_set_ct(context,ct)
BSprocinfo	*context;
int	ct;
{
	context->coloring_type = ct;
}

/*@ BSctx_set_err - Set the type of error checking

	Input Parameters: 
.   context - The context to change
.   err - If err is TRUE, then we do some rudimentary error
.         checking on the incoming matrix and some intermediate
.         results.  The error checking is fast.

    Returns:
    void

 @*/
void	BSctx_set_err(context,err)
BSprocinfo	*context;
int	err;
{
	context->error_check = err;
}

/*@ BSctx_set_rt - Set whether information for fast future permutations
.                  with the same matrix structure should be kept

	Input Parameters: 
.   context - The context to change
.   rt - if TRUE, then the information is kept around

    Returns:
    void

 @*/
void	BSctx_set_rt(context,rt)
BSprocinfo	*context;
int	rt;
{
	context->retain = rt;
}

/*@ BSctx_set_pr - Set whether information on reordering should be printed

	Input Parameters: 
.   context - The context to change
.   pr - if TRUE, then print the  information

    Returns:
    void

 @*/
void	BSctx_set_pr(context,pr)
BSprocinfo	*context;
int	pr;
{
	context->print = pr;
}

/*@ BSctx_set_si - Set whether or not inodes and cliques will be found

	Input Parameters: 
.   context - The context to change
.   si - if TRUE, then no cliques or inodes are found

    Returns:
    void

	Notes:
	This option allows more efficient execution when no cliques or
    i-nodes exist in the graph
 @*/
void	BSctx_set_si(context,si)
BSprocinfo	*context;
int	si;
{
	context->single = si;
}
