#include "BSprivate.h"

/*+ BScolor_2_clique - Figure out the connection between the
                       coloring and the cliques.

    Input Parameters:
.   color_base - the global base numbers for the colors
.   cA - the clique data structure

    Returns:
    the indices for where each color starts in the array of cliques

+*/
BSnumbering *BScolor_2_clique(color_base,cA)
BSnumbering *color_base;
BScl_2_inode *cA;
{
	int	cl_ind;
	int	i;
	BSnumbering *map;

	/* Figure out where each color starts in the array of cliques */
	map = BSalloc_numbering(color_base->length); CHKERRN(0);
	cl_ind = 0;
	for (i=0;i<color_base->length;i++) {
		map->numbers[i] = cl_ind;
		while ((cA->g_offset[cl_ind] < color_base->numbers[i+1]) &&
			(cl_ind <= cA->num_cols)) cl_ind++;
	}
	return(map);
}
