#include	"BSprivate.h"

/*+ BSclique_2_inode - Connect the clique data structure to
                       the inode data structure

    Input Parameters:
.   A - The sparse matrix
.   cl_array - the clique data structure
.   in_array - the inode data structure
.   procinfo - the usual processor info

    Output Parameters:
.   cl_array - on exit, this data structure is modified to
               index into in_array.  In addition, the
               dense matrices associated with the cliques
               are allocated.

    Returns:
    void

+*/
void	BSclique_2_inode(A,cl_array,in_array,procinfo)
BSspmat *A;
BScl_2_inode *cl_array;
BSinode_list *in_array;
BSprocinfo *procinfo;
{
	int	cl_ind, in_ind;
	int	local_ind;
	int	length;

	/* figure out the connection of cl_array to in_array */
	local_ind = 0;
	in_ind = 0;
	for (cl_ind=0;cl_ind<cl_array->num_cols;cl_ind++) {
		cl_array->inode_index[cl_ind] = in_ind;
		length = 0;
		while (in_array->list[in_ind].gcol_num < cl_array->g_offset[cl_ind+1]) {
			length += in_array->list[in_ind].num_cols;
			in_ind++;
		}
		/* allocate the dense matrix associated with this clique */
		/* otherwise, just indicate the size of the clique as a neg. number */
		if (procinfo->my_id == cl_array->proc[cl_ind]) {
			cl_array->d_mats[cl_ind].size = length;
			cl_array->d_mats[cl_ind].local_ind = local_ind;
			MY_MALLOC(cl_array->d_mats[cl_ind].matrix,(FLOAT *),
				sizeof(FLOAT)*length*length,1);
			local_ind += length;
		} else {
			cl_array->d_mats[cl_ind].size = -length;
			cl_array->d_mats[cl_ind].matrix = NULL;
		}
	}
	cl_array->inode_index[cl_array->num_cols] = in_array->length;

}
