#include "BSprivate.h"

/*@ BSbjacobi - Apply the block Jacobi preconditioner

    Input Parameters:
.   A - The sparse matrix
.   x - a vector
.   comm - the compiled communication pattern
.   procinfo - the usual processor info

    Input Parameters:
.   x - the preconditioner applied to the vector

    Returns:
    void

 @*/
void BSbjacobi(A,x,comm,procinfo)
BSpar_mat *A;
FLOAT *x;
BScomm *comm;
BSprocinfo *procinfo;
{
	BMphase *to_phase, *from_phase;
	BMmsg *msg;
	int	i, j, k;
	int	cl_ind, in_ind;
	int	count, size, ind, num_cols;
	int *row;
	FLOAT *nz;
	BScl_2_inode *clique2inode;
	BSnumbering *color2clique;
	BSinode *inodes;
	int	*data_ptr, msg_len;
	FLOAT *msg_buf, *matrix;
	FLOAT *work, *nzptr;
	char UP = 'U';
	char TR = 'T';
	char NTR = 'N';
	char ND = 'N';
	int	ione = 1;
	FLOAT one = 1.0;
	FLOAT zero = 0.0;

	color2clique = A->color2clique;
	clique2inode = A->clique2inode;
	inodes = A->inodes->list;

	/* now do this phase by phase */
	for (i=0;i<color2clique->length-1;i++) {
		/* find my portion of the solution using the cliques on the diagonal */
		for (cl_ind=color2clique->numbers[i];
			cl_ind<color2clique->numbers[i+1];cl_ind++) {
			if (procinfo->my_id == clique2inode->proc[cl_ind]) {
				/* first, multiply the clique */
				/* the clique is stored, inverted, in the upper triangle */
				size = clique2inode->d_mats[cl_ind].size;
				ind = clique2inode->d_mats[cl_ind].local_ind;
				matrix = clique2inode->d_mats[cl_ind].matrix;
				DTRMV(&UP,&TR,&ND,&size,matrix,&size,&(x[ind]),&ione);
				DTRMV(&UP,&NTR,&ND,&size,matrix,&size,&(x[ind]),&ione);
				MLOG_flop((2*(size*(size+1))));
			}
		}
	}
}
