#include "BSprivate.h"

/*+ BSbase - Figure out how to do a global numbering of rows
             based on each processors distribution of colors.

    Input Parameters:
.   distr - the local distribution
.   procinfo - the usual processor information

    Returns:
    numbering that gives global base number for each color

    Notes: 
    For example, if processor 0 has 2 of color 0 and 3 of color 1
    and processor 1 has 3 of color 0, 2 of color 1, and 2 of color 2,
    the global base numbering is 0 5 10.
+*/
BSnumbering *BSbase(distr,procinfo)
BSdistribution *distr;
BSprocinfo *procinfo;
{
	int	i, count;
	int	work, *workv;
	int	maxval;
	BSnumbering *base;

	/* get maximum length of distr, globally */
	maxval = distr->max+1;
	GIMAX(&maxval,1,&work,procinfo->procset);

	/* allocate a number of the proper size */
	base = BSalloc_numbering(maxval+1); CHKERRN(0);

	/* calculate the global distribution via a global sum */
	for (i=0;i<base->length;i++) base->numbers[i] = 0;
	for (i=0;i<distr->max+1;i++) {
		base->numbers[i] = distr->distribution[i];
	}
	MY_MALLOCN(workv,(int *),sizeof(int)*(base->length-1),1);
	GISUM(base->numbers,base->length-1,workv,procinfo->procset);
	MY_FREEN(workv);

	/* now figure out the global base numbering */
	count = 0;
	for (i=0;i<base->length;i++) {
		work = base->numbers[i];
		base->numbers[i] = count;
		count += work;
	}
	return(base);
}
