#include "BSprivate.h"

/*@ BSbackward - Backward triangular matrix multiplication on a 
                 single vector

    Input Parameters:
.   A - The sparse matrix
.   x - The input vector
.   comm - The communication structure for A
.   procinfo - the usual processor information

    Output Parameters:
.   b - on exit contains A*x

    Returns:
    void

 @*/
void BSbackward(A,x,b,comm,procinfo)
BSpar_mat *A;
FLOAT *x;
FLOAT *b;
BScomm *comm;
BSprocinfo *procinfo;
{
	BMcomp_msg *from_msg, *to_msg;
	BMphase *to_phase, *from_phase;
	BMmsg *msg;
	int	i, j, k;
	int	cl_ind, in_ind;
	int	count, size, ind, num_cols;
	int *row;
	FLOAT *nz;
	BScl_2_inode *clique2inode;
	BSnumbering *color2clique;
	BSinode *inodes;
	int	*data_ptr, msg_len;
	FLOAT *msg_buf, *matrix;
	FLOAT *work, *nzptr;
	char UP = 'L';
	char TR = 'T';
	char ND = 'N';
	int	ione = 1;
	FLOAT one = 1.0;
	FLOAT zero = 0.0;
	FLOAT DDOT();

	color2clique = A->color2clique;
	clique2inode = A->clique2inode;
	inodes = A->inodes->list;

	/* get some work space */
	MY_MALLOC(work,(FLOAT *),sizeof(FLOAT)*A->num_rows,1);

	/* REMEMBER, the to and from phase are switched here */
	from_msg = comm->to_msg;
	to_msg = comm->from_msg;

	/* post for all messages */
	BMinit_comp_msg(from_msg,procinfo); CHKERR(0);

	/* REMEMBER, the diagonal has already been taken care */

	/* now do this phase by phase */
	for (i=color2clique->length-2;i>=0;i--) {
		/* first send my messages */
		/* this will involve computing partial sums */
		to_phase = BMget_phase(to_msg,i); CHKERR(0);
		msg = NULL;
		while ((msg = BMnext_msg(to_phase,msg)) != NULL) {
			CHKERR(0);
			msg_buf = (FLOAT *) BMget_msg_ptr(msg); CHKERR(0);
			data_ptr = BMget_user(msg,&msg_len); CHKERR(0);
			count = 0;
			for (cl_ind=data_ptr[0];cl_ind<=data_ptr[1];cl_ind++) {
				for (in_ind=clique2inode->inode_index[cl_ind];
					in_ind<clique2inode->inode_index[cl_ind+1];in_ind++) {
					row = inodes[in_ind].row_num;
					nz = inodes[in_ind].nz;
					size = inodes[in_ind].length;
					num_cols = inodes[in_ind].num_cols;
					if (size > 0) {
						for (k=0;k<size;k++) work[k] = x[row[k]];
						DGEMV(&TR,&size,&num_cols,&one,nz,&size,
							work,&ione,&zero,&(msg_buf[count]),&ione);
					}
					count += num_cols;
				}
			}
			BMsendf_msg(msg); CHKERR(0);
		}
		CHKERR(0);
	}

	/* do some local work */
	for (i=color2clique->length-2;i>=0;i--) {
		for (cl_ind=color2clique->numbers[i];
			cl_ind<color2clique->numbers[i+1];cl_ind++) {
			if (procinfo->my_id == clique2inode->proc[cl_ind]) {
				/* first, multiply the clique */
				/* only do the strictly upper triangular part */
				/* we ASSUME the diagonal is all 1's */
				size = clique2inode->d_mats[cl_ind].size;
				ind = clique2inode->d_mats[cl_ind].local_ind;
				matrix = clique2inode->d_mats[cl_ind].matrix;
				if (size > 1) {
					j = size-1;
					DCOPY(&j,&(x[ind+1]),&ione,work,&ione);
					matrix++;
					DTRMV(&UP,&TR,&ND,&j,matrix,&size,work,&ione);
					DAXPY(&j,&one,work,&ione,&(b[ind]),&ione);
				}

				/* now, multiply the inodes */
				for (in_ind=clique2inode->inode_index[cl_ind];
					in_ind<clique2inode->inode_index[cl_ind+1];in_ind++) {
					row = inodes[in_ind].row_num;
					nz = inodes[in_ind].nz;
					size = inodes[in_ind].length;
					num_cols = inodes[in_ind].num_cols;
					if (size > 0) {
						for (k=0;k<size;k++) work[k] = x[row[k]];
						DGEMV(&TR,&size,&num_cols,&one,nz,&size,
							work,&ione,&one,&(b[ind]),&ione);
					}
					ind += num_cols;
				}
			}
		}
	}

	/* receive my messages and update my rhs */
	for (i=color2clique->length-2;i>=0;i--) {
		from_phase = BMget_phase(from_msg,i); CHKERR(0);
		while ((msg = BMrecv_msg(from_phase)) != NULL) {
			CHKERR(0);
			msg_buf = (FLOAT *) BMget_msg_ptr(msg); CHKERR(0);
			data_ptr = BMget_user(msg,&msg_len); CHKERR(0);
			msg_len = BMget_msg_size(msg); CHKERR(0);
			msg_len /= sizeof(FLOAT);
			count = 0;
			for (j=0;j<msg_len;j++) b[data_ptr[j]] += msg_buf[j];
			BMfree_msg(msg); CHKERR(0);
		}
		CHKERR(0);
	}
	MY_FREE(work);
	/* wait for all of the sent messages to finish */
	BMfinish_comp_msg(to_msg,procinfo); CHKERR(0);
	MLOG_flop((2*A->local_nnz));
}
