#include	"BSprivate.h"

/*+ BSalloc_permutation - Allocate the BSpermutation data structure

	Input Parameters: 
.   length - The length of the permutation

    Returns:
    The permutation data structure

+*/
BSpermutation	*BSalloc_permutation(length)
int	length;
{
	BSpermutation	*permutation;

	MY_MALLOCN(permutation,(BSpermutation *),sizeof(BSpermutation),1);
	MY_MALLOCN(permutation->perm,(int *),sizeof(int)*length,2);
	permutation->length = length;
	return(permutation);
}

/*+ BSreset_permutation - Reset the length of a permutation

	Input Parameters: 
.   length - The new length of the permutation
.   perm - the permutation data structure

    Returns:
    void

+*/
void	BSreset_permutation(length,perm)
int	length;
BSpermutation	*perm;
{

	perm->length = length;
}

/*+ BSfree_permutation - Free the BSpermutation data structure

	Input Parameters: 
.   permutation - The structure to be freed

    Returns:
    void

+*/
void	BSfree_permutation(permutation)
BSpermutation	*permutation;
{
	MY_FREE(permutation->perm);
	MY_FREE(permutation);
}
