#include	"BSprivate.h"

/*+ BSalloc_numbering - Allocate the BSnumbering data structure

	Input Parameters: 
.   length - The length of the numbering

    Returns:
    The allocated data structure

+*/
BSnumbering	*BSalloc_numbering(length)
int	length;
{
	BSnumbering	*numbering;

	MY_MALLOCN(numbering,(BSnumbering *),sizeof(BSnumbering),1);
	MY_MALLOCN(numbering->numbers,(int *),sizeof(int)*length,2);
	numbering->length = length;
	return(numbering);
}

/*+ BSfree_numbering - Free the BSnumbering data structure

	Input Parameters: 
.   numbering - The structure to be freed

    Returns:
    void

+*/
void	BSfree_numbering(numbering)
BSnumbering	*numbering;
{
	MY_FREE(numbering->numbers);
	MY_FREE(numbering);
}
