#include	"BSprivate.h"

/*+ BSalloc_key_arr - Allocate the BSkey_arr data structure

	Input Parameters: 
.   length - length of the structure

    Returns:
    The allocated data structure

+*/
BSkey_arr	*BSalloc_key_arr(length)
int	length;
{
	BSkey_arr	*key_arr;

	MY_MALLOCN(key_arr,(BSkey_arr *),sizeof(BSkey_arr),1);
	MY_MALLOCN(key_arr->array,(int **),sizeof(int *)*length,2);
	key_arr->length = length;
	return(key_arr);
}

/*+ BSfree_key_arr - Free the BSkey_arr data structure

	Input Parameters: 
.   key_arr - The structure to be freed

    Returns:
    void

+*/
void	BSfree_key_arr(key_arr)
BSkey_arr	*key_arr;
{
	int	i;

	for (i=0;i<key_arr->length;i++) {
		MY_FREE(key_arr->array[i]);
	}
	MY_FREE(key_arr->array);
	MY_FREE(key_arr);
}
