#include	"BSprivate.h"

/*+ BSalloc_distribution - Allocate the BSdistribution data structure

	Input Parameters: 
.   max - The maximum number in the distribution

    Returns:
    The allocated data structure

    Notes: The distributions begin at 0 and end at max.

+*/
BSdistribution	*BSalloc_distribution(max)
int	max;
{
	BSdistribution	*distr;

	MY_MALLOCN(distr,(BSdistribution *),sizeof(BSdistribution),1);
	MY_MALLOCN(distr->distribution,(int *),sizeof(int)*(max+1),2);
	distr->max = max;
	return(distr);
}

/*+ BSfree_distribution - Free the BSdistribution data structure

	Input Parameters: 
.   distr - The distribution structure to be freed

    Returns:
    void

+*/
void	BSfree_distribution(distr)
BSdistribution	*distr;
{
	MY_FREE(distr->distribution);
	MY_FREE(distr);
}
