#define MAINLOG
#include "pargrid.h"

/*+ main - the main routine for this grid program

     Input Parameters:
     argc, argv - the usual
     argv[1] - the number of points in each direction of the global grid
               do not use less than 2 points per processor
     argv[2] - the type of stencil (5 or 9)

     To Run, see tools.

     Notes: The grid program solves a linear system associated with
            a 2-D grid distributed across the processors.  The 2-D
            grid is partitioned in both dimensions amongst the
            processors.  The number of processors *must* be the
            square of an integer, e.g., 9 but not 8.

 +*/

main(argc,argv)
int	argc;
char	**argv;
{
	int	main2();

	PICall(main2,argc,argv);
	exit(0);
}

int main2(argc,argv)
int	argc;
char	**argv;
{
	par_grid grid;
	BSprocinfo *procinfo;
	int	t, work;
	double	dbl;

	/* set up the context for BlockSolve */
	procinfo = BScreate_ctx(); CHKERR(0);
	/* tell it that this matrix has no i-nodes or cliques */
	BSctx_set_si(procinfo,TRUE); CHKERR(0);
	/* tell it to print out some information on the reordering */
	BSctx_set_pr(procinfo,TRUE); CHKERR(0);

	/* initialize the logging */
	MLOG_INIT();

	/* read in grid parameters */
	if (argc != 3) {
		SETERRC(ARG_ERR,"Argument list not correct size\n");
		return;
	}
	dbl = procinfo->nprocs;
	grid.worker_x = sqrt(dbl);
	grid.worker_y = grid.worker_x;
    grid.worker_z = 1;
	if (procinfo->my_id == 0) {
		printf("Number of workers (x,y): %d %d\n",
			grid.worker_x,grid.worker_y);
	}
	if (procinfo->nprocs != grid.worker_x*grid.worker_y*grid.worker_z) {
		SETERRC(ARG_ERR,"Number of processors is not correct\n");
		return;
	}
	sscanf(argv[1],"%d",&grid.num_x);
	grid.num_y = grid.num_x;
	grid.num_z = 1;
	grid.l_num_x = grid.num_x / grid.worker_x;
	grid.l_num_y = grid.num_y / grid.worker_y;
	grid.l_num_z = grid.num_z;

	/* local grid size and type */
	sscanf(argv[2],"%d",&grid.type);
	if (procinfo->my_id == 0) {
		printf("Grid type = %d\n",grid.type);
	}

	if (procinfo->my_id == 0) {
		printf("Discretizations (x,y): %d %d\n",
			grid.num_x,grid.num_y);
	}

	/* call the worker */
	worker(&grid,procinfo); 

	/* print out the log info and return */
	MLOG_PRINT(procinfo->procset);
	BSfree_ctx(procinfo); CHKERR(0);

	return;
}
