#define MAINLOG
#include "pargrid.h"

/*+ main - the main routine for this grid program

     Input Parameters:
     argc, argv - the usual
     argv[1] - the number of processors in the x direction
     argv[2] - the number of processors in the y direction
     argv[3] - the number of processors in the z direction
     argv[4] - the number of points in the x direction on each processor
               do not use less than 3 points
     argv[5] - the number of points in the y direction on each processor
               do not use less than 3 points
     argv[6] - the number of points in the z direction on each processor
               do not use less than 3 points

     To Run, see tools.

     Notes: The grid program solves a linear system associated with
            a 3-D grid distributed across the processors.  The 3-D
            grid is partitioned in all three dimensions amongst the
            processors.  The processors on the left and right ends
            of the grid use a 7 pt stencil, those in the middle use
            a 27-pt stencil.  No real problem is being solved, we
            are just demonstrating the use of the linear system solver.

 +*/

main(argc,argv)
int	argc;
char	**argv;
{
	int	main2();

	PICall(main2,argc,argv);
	exit(0);
}

int main2(argc,argv)
int	argc;
char	**argv;
{
	par_grid grid;
	BSprocinfo *procinfo;
	int	t, work;

	/* set up the context for BlockSolve */
	procinfo = BScreate_ctx(); CHKERR(0);
	/* tell it that this matrix has no i-nodes or cliques */
	BSctx_set_si(procinfo,TRUE); CHKERR(0);
	/* tell it to print out some information on the reordering */
	BSctx_set_pr(procinfo,TRUE); CHKERR(0);

	/* initialize the logging */
	MLOG_INIT();

	/* read in grid parameters */
	if (argc < 7) {
		SETERRC(ARG_ERR,"Argument list too small\n");
		return;
	}
	sscanf(argv[1],"%d",&grid.worker_x);
	sscanf(argv[2],"%d",&grid.worker_y);
	sscanf(argv[3],"%d",&grid.worker_z);
	if (procinfo->my_id == 0) {
		printf("Number of workers (x,y,z): %d %d %d\n",
			grid.worker_x,grid.worker_y,grid.worker_z);
	}
	if (procinfo->nprocs != grid.worker_x*grid.worker_y*grid.worker_z) {
		SETERRC(ARG_ERR,"Number of processors is not correct\n");
		return;
	}
	sscanf(argv[4],"%d",&grid.num_x);
	sscanf(argv[5],"%d",&grid.num_y);
	sscanf(argv[6],"%d",&grid.num_z);

	/* local grid size and type */
	/* the end processors are 7-pt stencils, the others are 27-pt */
	if ((Mxpos((&grid),(procinfo)) == grid.worker_x-1) ||
		(Mxpos((&grid),(procinfo)) == 0)) {
		grid.l_num_x = grid.num_x;
		grid.type = 7;
	} else {
		grid.l_num_x = grid.num_x / 2;
		grid.type = 27;
	}
	grid.l_num_y = grid.num_y;
	grid.l_num_z = grid.num_z;
	grid.num_x = grid.l_num_x;
	GISUM(&grid.num_x,1,&work,procinfo->procset);
	grid.num_y = grid.l_num_y;
	GISUM((&grid.num_y),1,&work,procinfo->procset);
	grid.num_z = grid.l_num_z;
	GISUM((&grid.num_z),1,&work,procinfo->procset);

	if (procinfo->my_id == 0) {
		printf("Discretizations (x,y,z): %d %d %d\n",
			grid.num_x,grid.num_y,grid.num_z);
	}

	/* call the worker */
	worker(&grid,procinfo); 

	/* print out the log info and return */
	MLOG_PRINT(procinfo->procset);
	BSfree_ctx(procinfo); CHKERR(0);

	return;
}
