#include	"pargrid.h"

/*@ ex3_freel2g - Free a local to global mapping

    Input Parameters:
.   data - the structure to be freed

    Returns:
    void

 @*/
void ex3_freel2g(data)
int	*data;
{
}

/*@ ex3_loc2glob - Map local row numbers to global row numbers

    Input Parameters:
.   length - the number of row numbers to map
.   req_array - the row numbers to map
.   procinfo - the usual processor information
.   map - the map to use

    Output Parameters:
.   ans_array - on exit, the corresponding global row numbers

    Returns:
    void

    Notes:
    Only valid for local row numbers that reside on the calling processor

 @*/
void ex3_loc2glob(length,req_array,ans_array,procinfo,map)
int	length;
int	*req_array;
int	*ans_array;
BSprocinfo *procinfo;
BSmapping	*map;
{
	int	i;
	par_grid *grid;
	int	x_offset, y_offset, l_x_pos, l_y_pos;

	grid = (par_grid *) map->vlocal2global;
	x_offset = Mxpos(grid,procinfo)*grid->l_num_x;
	y_offset = Mypos(grid,procinfo)*grid->l_num_y;
	for (i=0;i<length;i++) {
		l_x_pos = req_array[i] / grid->l_num_y;
		l_y_pos = req_array[i] % grid->l_num_y;
		ans_array[i] = ((x_offset+l_x_pos)*grid->worker_y*grid->l_num_y) +
						y_offset+l_y_pos;
	}
}

/*@ ex3_glob2proc - Map global row numbers to processor id's

    Input Parameters:
.   length - the number of row numbers to map
.   req_array - the row numbers to map
.   procinfo - the usual processor information
.   map - the map to use

    Output Parameters:
.   ans_array - on exit, the corresponding processor id's

    Returns:
    void

 @*/
void ex3_glob2proc(length,req_array,ans_array,procinfo,map)
int	length;
int	*req_array;
int	*ans_array;
BSprocinfo *procinfo;
BSmapping	*map;
{
	int	i;
	par_grid *grid;
	int	proc_x, proc_y;

	grid = (par_grid *) map->vlocal2global;
	for (i=0;i<length;i++) {
		proc_y = (req_array[i] % (grid->l_num_y*grid->worker_y))
			/ grid->l_num_y;
		proc_x = (req_array[i] / (grid->l_num_y*grid->worker_y)) 
			/ grid->l_num_x;
		ans_array[i] = (proc_y*grid->worker_x) + proc_x;
	}
}

/*@ ex3_freeg2l - Free a global to local mapping

    Input Parameters:
.   data - the structure to be freed

    Returns:
    void

 @*/
void ex3_freeg2l(data)
int	*data;
{
}

/*@ ex3_glob2loc - Map global row numbers to local row numbers

    Input Parameters:
.   length - the number of row numbers to map
.   req_array - the row numbers to map
.   procinfo - the usual processor information
.   map - the map to use

    Output Parameters:
.   ans_array - on exit, the corresponding local row numbers or
                a -1 if the row does not reside on the calling processor
               

    Returns:
    void

 @*/
void ex3_glob2loc(length,req_array,ans_array,procinfo,map)
int	length;
int	*req_array;
int	*ans_array;
BSprocinfo *procinfo;
BSmapping	*map;
{
	int	i;
	par_grid *grid;
	int	x_offset, y_offset, l_x_pos, l_y_pos;

	grid = (par_grid *) map->vlocal2global;
	x_offset = Mxpos(grid,procinfo)*grid->l_num_x;
	y_offset = Mypos(grid,procinfo)*grid->l_num_y;
	ex3_glob2proc(length,req_array,ans_array,procinfo,map); CHKERR(0);
	for (i=0;i<length;i++) {
		if (ans_array[i] != procinfo->my_id) {
			ans_array[i] = -1;
		} else {
			l_y_pos = (req_array[i] % (grid->worker_y*grid->l_num_y)) -
				y_offset;
			l_x_pos = (req_array[i] / (grid->worker_y*grid->l_num_y)) -
				x_offset;
			ans_array[i] = (l_x_pos*grid->l_num_y) + l_y_pos;
		}
	}
}

