#include "pargrid.h"
#define ROW_LEN 7

/*+ get_mat - Generate a sparse matrix from the given grid

     Input Parameters:
     grid - the given grid

     Returns:
     the sparse matrix

 +*/

BSspmat *get_mat(grid,procinfo)
par_grid *grid;
BSprocinfo *procinfo;
{
	BSspmat *A;
	int	i, j, k, l;
	int	ptype, pnum;
	int	*i_ptr;
	int	count;
	point	***points = grid->points;
	int	*rp,*cval;
	FLOAT	*aval;

	/* allocate space for the sparse matrix */
	rp = (int *) MALLOC((grid->local_total+1)*sizeof(int));
	cval = (int *) MALLOC((grid->local_total*7)*sizeof(int));
	aval = (FLOAT *) MALLOC((grid->local_total*7)*sizeof(FLOAT));

	/* ****************************************************** */
	/* now put values in the matrix                           */
	/* ****************************************************** */
	count = 1;
	rp[0] = 0;
	for (i=1;i<grid->l_num_x+1;i++) {
		for (j=1;j<grid->l_num_y+1;j++) {
			for (k=1;k<grid->l_num_z+1;k++) {
				pnum = points[i][j][k].num;
				ptype = points[i][j][k].type;
				rp[count] = rp[count-1];

				/* diagonal, set the column number, the nonzero values and */
				/* increment the length of the row */
				cval[rp[count]] = pnum;
				aval[rp[count]] = 1.0;
				rp[count]++;

				/* east */
				if (points[i+1][j][k].num >= 0) {
					cval[rp[count]] = points[i+1][j][k].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}

				/* west */
				if (points[i-1][j][k].num >= 0) {
					cval[rp[count]] = points[i-1][j][k].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}

				/* north */
				if (points[i][j+1][k].num >= 0) {
					cval[rp[count]] = points[i][j+1][k].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}

				/* south */
				if (points[i][j-1][k].num >= 0) {
					cval[rp[count]] = points[i][j-1][k].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}

				/* up */
				if (points[i][j][k+1].num >= 0) {
					cval[rp[count]] = points[i][j][k+1].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}

				/* down */
				if (points[i][j][k-1].num >= 0) {
					cval[rp[count]] = points[i][j][k-1].num;
					aval[rp[count]] = -(1.0/6.0);
					rp[count]++;
				}
				/* sort the values in this row */
				BSheap_sort1d(rp[count]-rp[count-1],&(cval[rp[count-1]]),
					&(aval[rp[count-1]])); CHKERRN(0);
				count++;
			}
		}
	}
	A = BSeasy_A(grid->offset,grid->local_total,rp,cval,aval,procinfo); 
	CHKERRN(0);
	return(A);
}
