/*+ BSprivate.h - Include file for the sparse solver package.  
    This file is for use only inside the BlockSolve package.
 +*/

#ifndef __BSprivateh
#define __BSprivateh

/* include the "system" dependent routines */
#include "BSdepend.h"

/* include the "public" include file as well */
#include "BSsparse.h"

/* include the special message passing stuff that I wrote */
#include "BMmsg.h"

/* ****************************************************************** */
/* Definitions of misc. constants */
/* ****************************************************************** */

#define MAT_NAME_MSG          10000
#define RHS_NAME_MSG          10001
#define OFFSETD_MSG           10002
#define OFFSETU_MSG           10003
#define BB_SQ_MSG             10004
#define BB_SA_MSG             10005
#define COLOR_MSG             10006
#define SETUP_FORWARD_MSG     10007
#define SETUP_ORIGINAL_MSG    10008
#define SETUP_FACTOR_MSG      10009
#define DEGREE_MSG            10010
/* these next three messages need a lot of room */
/* this next message number is actually a range of messages */
/* needed by the BMcomp_msg routines.  The total number */
/* of messages used is MAX_NUM_MSGS*nprocs */
/* MAX_NUM_MSGS should be greater than the number of messages */
/* that a processor sends in one compiled message execution */
/* For example, one compiled message execution is typically */
/* an entire parallel forward matrix solution.  So the number */
/* of messages is less than or equal to the number of processors */
/* that a single processor is connected to in the graph of the */
/* matrix times the number of colors used to color the graph */
/* we think the current setting of 10,000 is ample, but feel free */
/* to change it (recompile EVERYTHING if you do) */
#define COMP_MSG_BASE 10020
#define MAX_NUM_MSGS		10000

/* used in coloring */
#define NO_COLOR -2

/* used in cg and symmlq */
#define CG_MATVECR 1
#define CG_MATVECZ 2
#define CG_MSOLVE 3
#define CG_ERROR -1
#define SYMM_MATVECXR 1
#define SYMM_MATVECVZ 2
#define SYMM_MSOLVE1 3
#define SYMM_MSOLVE2 4
#define SYMM_MSOLVEB 5
#define SYMM_DONE 6
#define SYMM_ERROR -1

#define TRUE 1
#define FALSE 0

/* ****************************************************************** */
/* End of section */
/* ****************************************************************** */


/* ****************************************************************** */
/* Definitions of data structures */
/* ****************************************************************** */

/* used to store new global address for each row */
typedef struct __BSkey_arr {
	int	length;
	int	**array;
} BSkey_arr;

/* Bulletin Board */
typedef struct __BSbb {
	int	length;     /* the number of elements */
	BSmapping *map;	/* the mapping to use */
	int	*info;		/* the information to store in the BB */
} BSbb;

/* Bulletin Board for floating point */
typedef struct __BSbb_d {
	int	length;     /* the number of elements */
	BSmapping *map; /* the mapping to use */
	FLOAT	*info;	/* the information to store in the BB */
} BSbb_d;

/* ****************************************************************** */
/* End of section */
/* ****************************************************************** */


/* ****************************************************************** */
/* Definitions of misc macros */
/* ****************************************************************** */

#define MY_SETERR(a) {SETERR(a); return;}
#define MY_SETERRN(a) {SETERR(a); return(NULL);}
#define MY_SETERRC(a,s) {SETERRC(a,s); return;}
#define MY_SETERRCN(a,s) {SETERRC(a,s); return(NULL);}
#define MY_MALLOC(a,b,c,d) { \
if (c == 0) { \
	a = NULL; \
} else { \
	if ((a = b MALLOC(c)) == NULL) {MY_SETERRC(MEM_ERROR,"Out of Memory\n");} \
} \
} 
#define MY_MALLOCN(a,b,c,d) { \
if (c == 0) { \
	a = NULL; \
} else { \
	if ((a = b MALLOC(c)) == NULL) {MY_SETERRCN(MEM_ERROR,"Out of Memory\n");} \
} \
} 
#define MY_FREE(a) \
{ \
	if (a != NULL) FREE(a); \
}
#define MY_FREEN(a) \
{  \
	if (a != NULL) FREE(a); \
}

/* ****************************************************************** */
/* End of section */
/* ****************************************************************** */

/* ****************************************************************** */
/* Declarations of my functions */
/* ****************************************************************** */

BSnumbering *BSfnd_inode();
BSnumbering *BSalloc_numbering();
void BSfree_numbering();
BSpermutation *BSnum2perm();
BSpermutation *BSalloc_permutation();
void BSfree_permutation();
void BSreset_permutation();
BSdistribution *BSalloc_distribution();
void BSfree_distribution();
BSdistribution *BSnum2distr();
BSnumbering *BSfnd_clique();
BSkey_arr *BSalloc_key_arr();
void BSperm_ivec();
void BSperm_dvec();
void BSperm2iperm();
BSspmat	*BSdo_contract();
BSbb	*BSinit_bb();
void    BSfree_bb();
void    BSpost_bb();
void    BSpost_noaddr_bb();
void    BSquery_match_bb();
void    BSquery_nomatch_bb();
BSbb_d	*BSinit_bb_d();
void    BSfree_bb_d();
void    BSpost_bb_d();
void    BSpost_noaddr_bb_d();
void    BSquery_match_bb_d();
void    BSquery_nomatch_bb_d();
void BSx_color();
void BSido_color();
void BSsdo_color();
void BSpack_n_send();
int	BSmy_rand();
BSnumbering	*BSoff_gnum();
BSdistribution *BSfold_distr();
BScl_2_inode *BStrans_perm_cl();
BSinode_list *BStrans_perm_in();
void BSclique_2_inode();
void BSrem_diag();
void BSins_diag();
BSkey_arr	*BSperm_rows();
void BSrows_2_inode();
void BSnz_2_inode();
void BSsort_rows();
BSpermutation *BSglobal_perm();
BSsprow **BSrow_perm();
void BSfree_cl_2_inode();
void BSfree_inode_list();
BSnumbering *BSlow2high();
BSnumbering *BSbase();
BSnumbering *BScolor_2_clique();
void BSfree_reperm();
void BSorig_inode();
FLOAT BSpar_ip();
void BSpar_bip();
int	BSpar_cg();
int	BSpar_symmlq();
int	BSpar_bcg();
void BSupdt_matrix();
void BSupdt_matrix1();
void BSrow_err_check();
int	BScount_nz();
int BSnonlocalnz();
void	BScopy_cliques();
void BSheap_sort0();
void BSheap_sort1();
void BSheap_sort2();
void BSheap_sorthl1();
void BSheap_sort1d();
void BSiheap_sort1();
void BSiheap_sort2();
int BSfactor1();
int BSfactorn();

/* ****************************************************************** */
/* End of section */
/* ****************************************************************** */
#endif
