
#ifndef __BSdependh
#define __BSdependh

/* ********************************************************************** */
/* Some "system" dependencies */
/* We have put all the system dependent routines that are provided by */
/* the Chameleon/PETSc system here.  We have isolated them to make it */
/* easier to substitute something else for them.  We have provided a */
/* "NULL" version of them to get started. */
/* To link examples using this NULL version, use Makefile.NULL; the example */
/* codes won't run because the NULL routines don't do anything, but the code */
/* can be compiled and linked w/o Chameleon/PETSc */

/* If __BS_USE_CHAMELEON is defined, then we use Chameleon */
#define __BS_USE_CHAMELEON

#ifdef __BS_USE_CHAMELEON
#include "system/system.h"
#include "comm/comm.h"

#else

/* set up the right "Fortran naming" definitions for use in BSsparse.h
/* somehow the name of your architecture must be identified */
/* the following setup works for the *vast* majority of systems */
/* this affects only the linking of the blas and lapack routines called */
/*
       FORTRANCAPS:       Names are uppercase, no trailing underscore
       FORTRANUNDERSCORE: Names are lowercase, trailing underscore
*/
#if defined(titan) || defined(cray) || defined(ncube)
#define FORTRANCAPS
#elif !defined(rs6000) && !defined(NeXT) && !defined(HPUX)
#define FORTRANUNDERSCORE
#endif

/* SETERR(a), SETERRN(a) should set error codes and return */
#define SETERR(a)
#define SETERRN(a)

/* SETERR(a), SETERRN(a) should set error codes, print a string, and return */
#define SETERRC(a,s) 
#define SETERRCN(a,s) 

/* CHKERR(a), CHKERRN(a) check to see if an error code has been set, and
   if so, then return */
#define CHKERR(a)
#define CHKERRN(a)

/* MALLOC(c) should perform as malloc() */
#define MALLOC(c) malloc(c)

/* FREE(c) should perform as free() */
#define FREE(c) free(c)

/* RECVSYNCNOMEM(type,buf,length,data_type) is a synchronous receive */
/* of a message of type "type" into the memory pointed to by "buf" */
/* where "buf" points to a space of "length" bytes.  The message should */
/* contain data of type "data_type" -- at this time, BlockSolve routines */
/* send messages of mixed type for efficiency -- this means that the */
/* "data_type" field is often not completely accurate. */
#define RECVSYNCNOMEM(type,buf,length,data_type)

/* RECVSYNCUNSZ(type,buf,length,data_type) is a synchronous receive */
/* of a message of type "type" of unknown size.  Upon return, */
/* "buf" points to a space of "length" bytes.  The message should */
/* contain data of type "data_type" -- at this time, BlockSolve routines */
/* send messages of mixed type for efficiency -- this means that the */
/* "data_type" field is often not completely accurate. */
#define RECVSYNCUNSZ(type,buf,length,data_type)

/* RECVASYNCNOMEMFORCE(type,buf,length,data_type,msg_id) is an asynchronous */
/* receive of a message of type "type" into the memory pointed to by "buf" */
/* where "buf" points to a space of "length" bytes.  The message should */
/* contain data of type "data_type" -- at this time, BlockSolve routines */
/* send messages of mixed type for efficiency -- this means that the */
/* "data_type" field is often not completely accurate. */
/* The returned message ID is stored in "msg_id". */
#define RECVASYNCNOMEMFORCE(type,buf,length,data_type,msg_id)

/* the "data_type" field types are defined here */
#define MSG_INT 0
#define MSG_DBL 1

/* MYPROCID is the number of *this* processor */
#define MYPROCID 0

/* NUMNODES is the number of processors */
#define NUMNODES 1

/* RECVFROM() -- the sender of the last received message */
#define RECVFROM() 0

/* RECVLEN() -- the size of the last received message */
#define RECVLEN() 0

/* MSGFREERECV(msg) -- free a message received via RECVSYNCUNSZ */
#define MSGFREERECV(msg)

/* ASYNCPROBE(type) -- is there a message of "type" waiting */
#define ASYNCPROBE(type) 0

/* ASYNCDONE(id) -- is an asynchronous receive completed? */
#define ASYNCDONE(id) 0

/* the type definitions for message Id's */
typedef int ASYNCRecvId_t;
typedef int ASYNCSendId_t;

/* SENDASYNCNOMEMFORCE(type,buf,size,to_proc,data_type,msg_id) */
/* send the message in pointed to by "buf" of type "type" asynchronously */
/* to processor "to_proc" of data type "data_type" (as indicated above) */
/* where the message id is stored upon return in "msg_id" */
#define SENDASYNCNOMEMFORCE(type,buf,size,to_proc,data_type,msg_id)

/* SENDASYNCNOMEM(type,buf,size,to_proc,data_type,msg_id) */
/* same as SENDASYNCNOMEMFORCE */
#define SENDASYNCNOMEM(type,buf,size,to_proc,data_type,msg_id)

/* SENDSYNCNOMEM(type,buf,size,to_proc,data_type,msg_id) */
/* the synchronous version of SENDASYNCNOMEM */
#define SENDSYNCNOMEM(type,buf,size,to_proc,data_type)

/* SENDWAITNOMEM(type,buf,size,to_proc,data_type,msg_id) */
/* Wait for an asynchronous send (identified by "msg_id") to complete */
#define SENDWAITNOMEM(type,buf,size,to_proc,data_type,msg_id)

/* GISUM(sum_vec,vec_len,work_vec,procset) */
/* an integer vector sum across processors of vector "sum_vec" of */
/* length "vec_len" using an integer work vector, "work_vec", of */
/* equal length.  */
/* The processors participating are those in "procset" */
#define GISUM(sum_vec,vec_len,work_vec,procset)

/* GIMAX(sum_vec,vec_len,work_vec,procset) */
/* an integer vector max op across processors of vector "sum_vec" of */
/* length "vec_len" using an integer work vector, "work_vec", of */
/* equal length.  */
/* The processors participating are those in "procset" */
#define GIMAX(sum_vec,vec_len,work_vec,procset)

/* GDSUM(sum_vec,vec_len,work_vec,procset) */
/* a double precision vector sum across processors of vector "sum_vec" of */
/* length "vec_len" using a double precision work vector, "work_vec", of */
/* equal length.  */
/* The processors participating are those in "procset" */
#define GDSUM(sum_vec,vec_len,work_vec,procset)

/* GFSUM(sum_vec,vec_len,work_vec,procset) */
/* single precision version of GDSUM */
#define GFSUM(sum_vec,vec_len,work_vec,procset)

/* GSYNC(procset) -- a barrier for all the processors in procset */
#define GSYNC(procset)

/* GCOLX(lbuf,gsizes,gbuf,procset,datatype) - global collection in */
/* node number order with given sizes with data of type "datatype" in */
/* the processor set "procset". */
#define GCOLX(lbuf,gsizes,gbuf,procset,datatype)

/* PSNUMNODES(procset) is the number of nodes in the processor set */
#define PSNUMNODES(procset) 1

/* PSISROOT(procset) -- is this processor the "root" processor of the set */
#define PSISROOT(procset) 1

/* PSPROCLIST(procset,idlist) -- places the processor numbers in procset */
/* into the vector idlist */
#define PSPROCLIST(procset,idlist)

/* ProcSet is the structure that stores the set of processors that are */
/* are active -- generally, this is not important unless you want */
/* to specify a set of processors different from those used by the system */
typedef char *ProcSet;

/* the function PSNbrTree returns the parent, left child, or right child */
/* processor number is the processors are organized conceptually as a tree */
#define PSNbrTree(op_code,procset) 0
/* op_code is one of the following */
#define PS_PARENT 0
#define PS_LCHILD 1
#define PS_RCHILD 2

/* PICall(procedure,argc,argv) gets things started */
#define PICall(procedure,argc,argv) procedure(argc,argv)
#endif

/* ********************************************************************** */
/* this is a set of macros that retrofit the code for machines on which
   blocking sends are a bad idea.  These macros make all sends asynchronous
   by allocating buffers for the synchronous sends and cleaning up
   those buffers as we go */

/* To turn this code "on" simply define NO_BLOCKING_SEND */
/* For now, the only architecture that we know needs this is the rs6000 */
#if defined(rs6000)
#define NO_BLOCKING_SEND 1
#endif

typedef	struct __BSmsg_list {
	int	msg_type;
	char	*msg_buf;
	int	msg_len;
	int	msg_to;
	int	msg_data_type;
	ASYNCSendId_t	msg_id;
	struct	__BSmsg_list	*next;
} BSmsg_list;

#ifdef NO_BLOCKING_SEND
#define	MY_SEND_SYNC(Mmsg_list,Mmsg_type,Mmsg,Mmsg_len,Mmsg_to,Mmsg_data_type) \
{ \
	BSmsg_list	*node_99; \
	int	i99; \
	char	*tmsg_ptr99; \
	MY_MALLOC(node_99,(BSmsg_list *),sizeof(BSmsg_list),1); \
	node_99->next = Mmsg_list; \
	Mmsg_list = node_99; \
	if (Mmsg_len == 0) { \
		MY_MALLOC(node_99->msg_buf,(char *),1,2); \
	} else { \
		MY_MALLOC(node_99->msg_buf,(char *),Mmsg_len,3); \
	} \
	node_99->msg_type = Mmsg_type; \
	node_99->msg_len = Mmsg_len; \
	node_99->msg_to = Mmsg_to; \
	node_99->msg_data_type = Mmsg_data_type; \
	tmsg_ptr99 = (char *) Mmsg; \
	for (i99=0;i99<Mmsg_len;i99++) { \
		node_99->msg_buf[i99] = tmsg_ptr99[i99]; \
	} \
	SENDASYNCNOMEM(Mmsg_type,node_99->msg_buf,Mmsg_len,Mmsg_to,Mmsg_data_type, \
		node_99->msg_id); \
	CHECK_SEND_LIST(Mmsg_list); \
}
#else
#define	MY_SEND_SYNC(Mmsg_list,Mmsg_type,Mmsg,Mmsg_len,Mmsg_to,Mmsg_data_type) \
{ \
	SENDSYNCNOMEM(Mmsg_type,Mmsg,Mmsg_len,Mmsg_to,Mmsg_data_type); \
}
#endif

#define	MCHECK_SEND_LIST(Mmsg_list) \
{ \
	BSmsg_list	*node_ptr_99, *prev_node_ptr_99, *tnode_ptr_99; \
	node_ptr_99 = Mmsg_list; \
	prev_node_ptr_99 = Mmsg_list; \
	while (node_ptr_99 != NULL) { \
		if (ASYNCDONE(node_ptr_99->msg_id)) { \
			tnode_ptr_99 = node_ptr_99; \
			if (node_ptr_99 == Mmsg_list) { \
				Mmsg_list = Mmsg_list->next; \
				prev_node_ptr_99 = Mmsg_list; \
				node_ptr_99 = Mmsg_list; \
			} else { \
				prev_node_ptr_99->next = node_ptr_99->next; \
				node_ptr_99 = node_ptr_99->next; \
			} \
			MY_FREE(tnode_ptr_99->msg_buf); \
			MY_FREE(tnode_ptr_99); \
		} else { \
			prev_node_ptr_99 = node_ptr_99; \
			node_ptr_99 = node_ptr_99->next; \
		} \
	} \
}
#ifdef NO_BLOCKING_SEND
#define	CHECK_SEND_LIST(Mmsg_list) MCHECK_SEND_LIST(Mmsg_list)
#else
#define	CHECK_SEND_LIST(Mmsg_list)
#endif

#define MFINISH_SEND_LIST(Mmsg_list) \
{ \
	BSmsg_list	*tnode99; \
	while(Mmsg_list != NULL) { \
		tnode99 = Mmsg_list; \
		Mmsg_list = Mmsg_list->next; \
		SENDWAITNOMEM(tnode99->msg_type,tnode99->msg_buf,tnode99->msg_len, \
			tnode99->msg_to,tnode99->msg_data_type,tnode99->msg_id); \
		MY_FREE(tnode99->msg_buf); \
		MY_FREE(tnode99); \
	} \
}
#ifdef NO_BLOCKING_SEND
#define FINISH_SEND_LIST(Mmsg_list) MFINISH_SEND_LIST(Mmsg_list)
#else
#define FINISH_SEND_LIST(Mmsg_list)
#endif

#endif
