/*@ BMmsg.h - Include file for the compiled message-passing code.
              This code is indepedent (we hope) of the sparse matrix
              code.  The basic idea is to isolate the message-passing
              code from the sparse matrix code to allow optimizations
              to be done transparently.
 @*/

#ifndef __BMmsgh
#define __BMmsgh

/* the "preferred" maximum message size */
#define	PREFER_MAX_MSG_SIZE	262144

/* Definitions indicating the status of a message */
#define NOT_COMPLETED 0
#define COMPLETED 1

/* A description of the user-specified data being sent */
/* (whatever alignment malloc() gives us is what (*data) gets) */
typedef struct __BMuser_data {
	int	length;				/* length of the data */
	void *data;				/* pointer to the data */
	void (*free_data)();	/* pointer to a function for freeing the data */
} BMuser_data;

/* A description of a message */
typedef struct __BMmsg {
	int	phase;				/* the phase to which this message belongs */
	int	msg_type;			/* message type: standard interpretation */
	int	proc;				/* processor to/from */
	int	size;				/* size of the message, in bytes */
	BMuser_data user_data;	/* user data structure (see above) */
	BMuser_data setup_data;	/* user data structure for setting up message */
	char *msg;				/* the actual message */
	int	msg_data_type;		/* the data type of the messages (see tools) */
	ASYNCRecvId_t	recv_id;/* message id (used if async. recv) */
	ASYNCSendId_t	send_id;/* message id (used if async. recv) */
	int	status;				/* COMPLETED/NOT COMPLETED */
	int	alloced;			/* message allocated or not allocated */
	struct __BMmsg *next;	/* pointer to next message in phase */
} BMmsg;

/* a group of messages to be sent/received in the same phase */
typedef struct __BMphase {
	int	phase;				/* phase number */
	BMmsg *msg_list;		/* pointer to a list of messages */
	BMmsg *end_msg_list;	/* pointer to the end of msg_list */
	struct __BMphase *next;	/* pointer to next phase */
	BMmsg	*cur_list_ptr;	/* current pointer in the list, if any */
	char	*cur_recv_msg;	/* holds the current blocked message for freeing */
	BSmsg_list	*cur_msg;	/* pointer the current message block, if any */
							/* this is ONLY used when messages are grouped */
							/* rather than sent individually */
	BSmsg_list	*async_list;	/* pointer to list of outstanding messages */
							/* this is ONLY used when messages are grouped */
							/* rather than sent individually */
} BMphase;

/* the compiled message structure consisting of several phases */
typedef struct __BMcomp_msg {
	int	num_phases;			/* number of phases */
	BMphase	*phase_list;	/* pointer to a list of phases */
	int	base_type;			/* the base message type for this compiled
							   message structure.  The structure will
                               use message numbers from base_type to
                               num_phases*num_processors; up to a
                               maximum of MAX_NUM_MSGS at which point
                               an error will occur and the code will
                               generate an error message. */
	int	num_msgs;			/* total number of messages in this structure */
} BMcomp_msg;

/* list of function declarations for BMcomp_msg.c */
BMcomp_msg *BMcomp_init();
void BMfree_comp_msg();
BMphase *BMget_phase();
void BMadd_msg();
BMmsg *BMcreate_msg();
int BMget_msg_size();
void BMset_msg_size();
void BMinit_user();
void BMfree_user();
void BMfree_user_data();
void BMfree_setup_data();
void BMset_user();
void BMset_user_data();
void BMset_setup_data();
void *BMget_user();
void *BMget_setup();
void BMset_msg_ptr();
char *BMget_msg_ptr();
BMmsg *BMnext_msg();
void BMalloc_msg();
int BMfix_send();
void BMinit_comp_msg();
void BMfinish_comp_msg();
void BMsendf_msg();
void BMsend_msg();
void BMsend_block_msg();
BMmsg *BMrecv_msg();
BMmsg *BMrecv_block_msg();
void BMfree_msg();
void BMfree_block_msg();
void BMfinish_on_async_block();
void BMcheck_on_async_block();

#endif
