/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "zcoef.h"
#include <stdlib.h>
void /*FUNCTION*/ zcoef(
long n,
double zrt[][2],
double zc[][2])
{
	long int i, j;
	double fac[2], rti, rtr, tem, zci, zcr;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Fac = &fac[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1995-11-29 ZCOEF  Krogh   Converted from SFTRAN to Fortran 77
	 *>> 1987-09-16 ZCOEF  Lawson  Initial code.
	 * Conversion should only be done from "Z" to "C" for processing to C.
	 *--Z replaces "?": ?COEF
	 *
	 *     Given N complex numbers, this subr computes the (complex)
	 *     coefficients of the Nth degree monic polynomial having these
	 *     numbers as its roots.
	 *     C. L. Lawson, JPL, 1987 Feb 13.
	 *
	 *     N     [In, Integer]  Number of given roots and degree of poly.
	 *     ZRT() [In, DP]  The given ith complex root is (ZRT(1,i), ZRT(2,i))
	 *     ZC()  [Out, DP]  The (complex) coefficient of z**j will be stored
	 *           in (ZC(1,N+1-j), ZC(2,N+1-j)) for j = 0, ...,N+1.  The high
	 *           order coeff will be one, i.e.
	 *                (ZC(1,1), ZC(2,1)) = (1.0, 0.0).
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	zc[0][0] = 1.e0;
	zc[0][1] = 0.e0;
	zc[1][0] = -zrt[0][0];
	zc[1][1] = -zrt[0][1];
	for (i = 2; i <= n; i++)
	{
		zcr = zc[i - 1][0];
		zci = zc[i - 1][1];
		rtr = zrt[i - 1][0];
		rti = zrt[i - 1][1];
		tem = zcr*rtr - zci*rti;
		zci = zcr*rti + zci*rtr;
		zcr = tem;
		zc[i][0] = -zcr;
		zc[i][1] = -zci;
		for (j = i; j >= 2; j--)
		{
			zcr = zc[j - 2][0];
			zci = zc[j - 2][1];
			Fac[1] = zcr*rtr - zci*rti;
			Fac[2] = zcr*rti + zci*rtr;
			zc[j - 1][0] -= Fac[1];
			zc[j - 1][1] -= Fac[2];
		}
	}
	return;
} /* end of function */
 
