/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "ssort.h"
#include <stdlib.h>
void /*FUNCTION*/ ssort(
float a[],
long m,
long n)
{
	long int bl, br, cl, cr, stackl[32], stackr[32], stktop;
	float partn, temp;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const A = &a[0] - 1;
	long *const Stackl = &stackl[0] - 1;
	long *const Stackr = &stackr[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1995-11-17 SSORT  Krogh  Converted SFTRAN to Fortran 77.
	 *>> 1994-10-19 SSORT  Krogh  Changes to use M77CON
	 *>> 1988-11-22  SSORT  Snyder  Initial code.
	 *--S replaces "?": ?SORT, ?SORTP
	 *
	 *     Sort the M:N-vector A into ascending order.
	 *
	 *     To sort an array A' into descending order, let A = -A'
	 *     To sort an array A' into ascending order according to the
	 *     absolute value of the elements let A = ABS(A').
	 *     To sort an array A' into decending order according to the
	 *     absolute value of the elements let A = -ABS(A').
	 *
	 *     To keep track of the original elements, use SSORTP.
	 * */
	/*--S Next line special: I */
 
	/*     *****     Local Variables     ************************************
	 *
	 * BL      is the left bound of the sub-array to be sorted at the next
	 *         step.
	 * BR      is the right bound of the sub array to be sorted at the next
	 *         step.
	 * CL      is the current left bound of the unsorted sub-array.
	 * CR      is the current right bound of the unsorted sub-array.
	 * PARTN   is the partition element.
	 * STACKL  keeps track of the left bounds of sub-arrays waiting to be
	 *         sorted.
	 * STACKR  keeps track of the right bounds of sub-arrays waiting to be
	 *         sorted.
	 * STKTOP  keeps track of the top of the stacks.
	 * TEMP    holds elements of A during exchanges.
	 * */
	/*--S Next line special: I */
 
	/*     *****     Executable Statements     ******************************
	 * */
	if (n - m >= 10)
	{
		stktop = 1;
		Stackl[1] = m;
		Stackr[1] = n;
L_10:
		;
		bl = Stackl[stktop];
		br = Stackr[stktop];
		stktop -= 1;
		/*           Choose a partitioning element.  Use the median of the first,
		 *           middle and last elements.  Sort them so the extreme elements
		 *           serve as sentinels during partitioning. */
		cl = (bl + br)/2;
		partn = A[cl];
		if (A[bl] > partn)
		{
			A[cl] = A[bl];
			A[bl] = partn;
			partn = A[cl];
		}
		if (A[bl] > A[br])
		{
			temp = A[br];
			A[br] = A[bl];
			A[bl] = temp;
		}
		if (partn > A[br])
		{
			A[cl] = A[br];
			A[br] = partn;
			partn = A[cl];
		}
		A[cl] = A[br - 1];
		A[br - 1] = partn;
		/*           Partition the sub-array around PARTN.  Exclude the above
		 *           considered elements from partitioning because they're al-
		 *           ready in the correct subfiles.  Stop scanning on equality to
		 *           prevent files containing equal values from causing a loop. */
		cl = bl;
		cr = br - 1;
L_20:
		;
L_30:
		cl += 1;
		if (A[cl] < partn)
			goto L_30;
L_40:
		cr -= 1;
		if (A[cr] > partn)
			goto L_40;
		if (cl > cr)
			goto L_50;
		temp = A[cl];
		A[cl] = A[cr];
		A[cr] = temp;
		goto L_20;
L_50:
		;
		/*           Put sub-arrays on the stack if they're big enough.  Put the
		 *           larger under the smaller, so the smaller will be done next.
		 *           This makes the upper bound of the stack depth log2 (n-m+1).
		 *           (The "Hibbard" modification of quicksort). */
		if (cl - bl > br - cr)
		{
			if (cl - bl > 10)
			{
				stktop += 1;
				Stackl[stktop] = bl;
				Stackr[stktop] = cr;
			}
			if (br - cr > 10)
			{
				stktop += 1;
				Stackl[stktop] = cl;
				Stackr[stktop] = br;
			}
		}
		else
		{
			if (br - cr > 10)
			{
				stktop += 1;
				Stackl[stktop] = cl;
				Stackr[stktop] = br;
			}
			if (cl - bl > 10)
			{
				stktop += 1;
				Stackl[stktop] = bl;
				Stackr[stktop] = cr;
			}
		}
		if (stktop != 0)
			goto L_10;
	}
	/*     Clean up small subfiles using insertion sort on everything. */
	for (cr = m + 1; cr <= n; cr++)
	{
		partn = A[cr];
		cl = cr;
L_60:
		if (A[cl - 1] > partn)
		{
			A[cl] = A[cl - 1];
			cl -= 1;
			if (cl > m)
				goto L_60;
		}
		A[cl] = partn;
	}
	return;
} /* end of function */
 
