/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "ssinhm.h"
#include <float.h>
#include <stdlib.h>
		/* PARAMETER translations */
#define	CUT	0.25e0
#define	SP1	.452867078563929e-01
#define	SP2	.954811583154274e-03
#define	SP3	.109233297700241e-04
#define	SP4	.723809046696880e-07
#define	SP5	.255251817302048e-09
#define	SQ1	(-.471329214363072e-02*6.0e0)
		/* end of PARAMETER translations */
 
float /*FUNCTION*/ ssinhm(
float x)
{
	long int _l0, n;
	float e, ssinhm_v, x2;
	static float round;
	static long m = -1;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>>   1998-10-29 SSINHM Krogh  Moved external statement up for mangle.
	 *>>   1994-10-20 SSINHM Krogh  Changes to use M77CON
	 *>>   1994-05-22 SSINHM WV Snyder JPL Make SP and DP alike using CHGTYP
	 *>>   1993-07-21 SSINHM WV Snyder JPL Original code
	 *
	 *     Compute SINH(X) - X.
	 *
	 *--S replaces "?": ?SINHM */
 
	if (m < 0)
	{
		round = FLT_EPSILON;
		if (round < 5.0e-14)
		{
			/*           Compute appropriate value of M depending on round-off. */
			m = 3;
			e = CUT/6.0e0;
L_10:
			if (e > round)
			{
				m += 2;
				e = e*CUT*CUT/(m*(m - 1));
				goto L_10;
			}
		}
	}
 
	if (round < 5.0e-14)
	{
		n = m;
		x2 = x*x;
		/*        We assume m > 1 */
		ssinhm_v = 1.0e0 + x2/(n*(n - 1));
L_20:
		if (n > 5)
		{
			n -= 2;
			ssinhm_v = 1.0e0 + ssinhm_v*x2/(n*(n - 1));
			goto L_20;
		}
		ssinhm_v = x*x2*ssinhm_v/6.0e0;
		return( ssinhm_v );
	}
 
	/*     Use a rational approximation when ABS(X) is less than 1.65,
	 *     else use the Fortran intrinsic function.
	 * */
	if (x < 1.65e0)
	{
		x2 = x*x;
		ssinhm_v = ((((((SP5*x2 + SP4)*x2 + SP3)*x2 + SP2)*x2 + SP1)*
		 x2 + 1.0e0)*x2*x)/(SQ1*x2 + 6.0e0);
	}
	else
	{
		ssinhm_v = sinhf( x ) - x;
	}
	return( ssinhm_v );
} /* end of function */
 
