/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:07 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sbesy1.h"
#include <float.h>
#include <stdlib.h>
float /*FUNCTION*/ sbesy1(
float x)
{
	long int _l0, _l1;
	float ampl, sbesy1_v, theta, y;
	static float by1cs[20]={.320804710061190862932352018628015e-1,
	 .126270789743350044953431725999727e1,.649996189992317500097490637314144e-2,
	 -.893616452886050411653144160009712e-1,.132508812217570954512375510370043e-1,
	 -.897905911964835237753039508298105e-3,.364736148795830678242287368165349e-4,
	 -.100137438166600055549075523845295e-5,.199453965739017397031159372421243e-7,
	 -.302306560180338167284799332520743e-9,.360987815694781196116252914242474e-11,
	 -.348748829728758242414552947409066e-13,.278387897155917665813507698517333e-15,
	 -.186787096861948768766825352533333e-17,.106853153391168259757070336000000e-19,
	 -.527472195668448228943872000000000e-22,.227019940315566414370133333333333e-24,
	 -.859539035394523108693333333333333e-27,.288540437983379456000000000000000e-29,
	 -.864754113893717333333333333333333e-32};
	static float twodpi = 0.636619772367581343075535053490057e0;
	static long nty1 = 0;
	static float xmin = 0.e0;
	static float xsml = 0.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const By1cs = &by1cs[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1996-03-30 SBESY1 Krogh  Added external statement.
	 *>> 1995-11-03 SBESY1 Krogh  Changes to simplify C conversion.
	 *>> 1994-11-11 SBESY1 Krogh  Declared all vars.
	 *>> 1994-10-20 SBESY1 Krogh  Changes to use M77CON
	 *>> 1991-01-14 SBESY1 CLL Changed to generic name SIN.
	 *>> 1990-11-29 CLL
	 *>> 1985-08-02 SBESY1 Lawson  Initial code.
	 * JULY 1977 EDITION.  W. FULLERTON, C3, LOS ALAMOS SCIENTIFIC LAB.
	 * C.L.LAWSON & S.CHAN, JPL, 1984 FEB ADAPTED TO JPL MATH77 LIBRARY.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?BESY1, ?BESJ1, ?BMP1, ?INITS, ?CSEVL, ?ERM1
	 *     ------------------------------------------------------------------ */
 
	/* SERIES FOR BY1        ON THE INTERVAL  0.          TO  1.60000E+01
	 *                                        WITH WEIGHTED ERROR   8.65E-33
	 *                                         LOG WEIGHTED ERROR  32.06
	 *                               SIGNIFICANT FIGURES REQUIRED  32.17
	 *                                    DECIMAL PLACES REQUIRED  32.71
	 * */
 
 
	/*     ------------------------------------------------------------------ */
	if (nty1 == 0)
	{
		sinits( by1cs, 20, 0.1e0*FLT_EPSILON/FLT_RADIX, &nty1 );
 
		xmin = 1.571e0*expf( fmaxf( logf( FLT_MIN ), -logf( FLT_MAX ) ) +
		 0.01e0 );
		xsml = sqrtf( 4.0e0*FLT_EPSILON/FLT_RADIX );
	}
 
	if (x <= 0.e0)
	{
		sbesy1_v = 0.e0;
		serm1( "SBESY1", 1, 0, "X IS ZERO OR NEGATIVE", "X", x, '.' );
	}
	else if (x <= xmin)
	{
		sbesy1_v = 0.e0;
		serm1( "SBESY1", 2, 0, "X SO SMALL Y1 OVERFLOWS", "X", x,
		 '.' );
	}
	else if (x <= 4.e0)
	{
		if (x <= xsml)
		{
			y = 0.e0;
		}
		else
		{
			y = x*x;
		}
		sbesy1_v = twodpi*logf( 0.5e0*x )*sbesj1( x ) + (0.5e0 + scsevl( .125e0*
		 y - 1.e0, by1cs, nty1 ))/x;
	}
	else
	{
		sbmp1( x, &ampl, &theta );
		sbesy1_v = ampl*sinf( theta );
	}
	return( sbesy1_v );
} /* end of function */
 
