/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:44 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dwcomp.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	NMAX	10
#define	NMAXP1	(NMAX + 1)
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ dwatan(
long n5,
double u5[],
double y5[])
{
	long int i, ns;
	double s1[NMAXP1];
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const U5 = &u5[0] - 1;
	double *const Y5 = &y5[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2001-06-18 DWCOMP Krogh   Replaced ". and." with " .and."
	 *>> 1996-04-15 DWCOMP Krogh   Changed single common block name to SWCOM.
	 *>> 1995-11-21 DWCOMP Krogh   Removed multiple entries for C conversion.
	 *>> 1994-11-11 DWCOMP Krogh   Declared all vars.
	 *>> 1994-10-31 DWCOMP Krogh  Changes to use M77CON
	 *>> 1987-12-07 DWCOMP Lawson  Initial code.
	 *--D replaces "?": ?WCOMP,?WATAN,?WASIN,?WACOS,?WATN2,?WSUM,?WDIF,
	 *--&   ?WSQRT,?WEXP,?WSIN,?WCOS,?WTAN,?WSINH,?WCOSH,?WTANH,?WSET,?WSUM1,
	 *--&   ?WDIF1,?WPRO1,?WQUO1,?WLOG,?WPWRI,?WCHN,?WPRO,?WQUO,?PASCL,
	 *--&   ?WRCHN,?WACSI,?WCOM
	 *
	 *     File DWCOMP [- Wengert derivative COMPutation]
	 *     The file DWCOMP contains a set of program units to perform
	 *     computation on (N+1)-tuples representing the value of a quantity
	 *     and its first N derivatives with respect to a single variable.
	 *     In the comments we use T as the name of the ultimate independent
	 *     variable.
	 *          The parameter NMAX must be set in program units
	 *                   DWATAN, DWSUM, and DWPRO
	 *     to establish the largest order of derivative the package
	 *     will be able to handle.
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *     C. L. Lawson, JPL, 1971.
	 *     References:
	 *     1.   Wengert, R. E., A simple automatic derivative evaluation
	 *          program, Comm. ACM, 1, Aug 1964, 463-464.
	 *     2.   C. L. Lawson, Computing Derivatives using W-arithmetic and
	 *          U-arithmetic., JPL Appl Math TM 289, Sept 1971.
	 *     Revised by CLL for Fortran 77 in Jan 1987.  Deleted subr WSTART.
	 *     Put a first time flag in WPRO.  Now user does not need to make
	 *     any initialization call.
	 *     9/18/87, CLL. Added new entry names DWASIN & DWACOS.
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *     NMAX        Setting NMAX in the parameter statement determines
	 *           the highest order derivative this program unit will be able
	 *           to handle.  The following arrays have dimensions depending
	 *           on NMAX:  S1(), S2(), S3(), S4(), C()
	 *
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *                         ERROR HANDLING
	 *
	 *     All detected error conditions are essentially fatal for the
	 *     requested operation.  We do not stop; rather, we issue an error
	 *     message and return.  By use of the the MATH77 library subroutine,
	 *     ERMSET, the user can change the error processing action to cause a
	 *     STOP following the error message.
	 *
	 *     Error  Called
	 *      No.    name   Explanation
	 *
	 *       1    DWASIN  Infinite deriv when arg = -1 or +1
	 *       1    DWACOS  Infinite deriv when arg = -1 or +1
	 *       2    DWSQRT  Infinite deriv when arg = 0
	 *       3    DWQUO1  Zero divisor
	 *       4    DWPWRI  U**M is infinite when U = 0 and M < 0
	 *       5    DWPRO   Require dimension NMAX .ge. NDERIV
	 *       6    DWQUO   Require dimension NMAX .ge. NDERIV
	 *       7    DWQUO   Zero divisor
	 *       8    DPASCL  Require N .ge. 0
	 *       9    DWRCHN  Require U(2) .ne. 0.
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *               PROGRAM UNITS, entry NAMES, and calls
	 *
	 *     All of these subroutine and entry names may be called directly by
	 *     a user, however, it is expected that DWCHN, DWRCHN, and DPASCL
	 *     would only be used to augment the package with new functions.
	 *
	 *     Subroutine names:                       Calls to:
	 *
	 *     subroutine DWATAN  (N5,U5,Y5)           DWPWRI,DWCHN
	 *     subroutine DWASIN (N16,U16,Y16)         DWACSI
	 *     subroutine DWACOS (N16,U16,Y16)         DWACSI
	 *     subroutine DWACSI (N16,U16,Y16,ACOSIN)  DWSQRT,DWPWRI,DWPRO1,DWCHN
	 *     subroutine DWATN2 (N9,Y9,X9,A9)      DWSUM,DWDIF,DWPRO,DWQUO,DWCHN
	 *
	 *     subroutine DWSUM  (NDERIV,U,V,W)        None
	 *     subroutine DWDIF  (N2,U2,V2,W2)         None
	 *     subroutine DWSQRT (N15,U15,Y15)         DWCHN
	 *     subroutine DWEXP  (N4,U4,Y4)            DWCHN
	 *     subroutine DWSIN  (N7,U7,Y7)            DWCHN
	 *     subroutine DWCOS  (N7,U7,Y7)            DWCHN
	 *     subroutine DWTAN  (N7,U7,Y7)            DWCHN
	 *     subroutine DWSINH (N7,U7,Y7)            DWCHN
	 *     subroutine DWCOSH (N7,U7,Y7)            DWCHN
	 *     subroutine DWTANH (N7,U7,Y7)            DWCHN, DWPRO, DWQUO
	 *     subroutine DWSET  (N10,UVAL,UDER,U10)   None
	 *     subroutine DWSUM1 (N11,C11,U11,Y11)     None
	 *     subroutine DWDIF1 (N12,C12,U12,Y12)     None
	 *     subroutine DWPRO1 (N13,C13,U13,Y13)     None
	 *     subroutine DWQUO1 (N14,C14,U14,Y14)     DWQUO
	 *
	 *     subroutine DWLOG  (NDERIV,U,Y)          DWCHN
	 *     subroutine DWPWRI (NDERIV,MPWR,U,Y)     DWCHN
	 *
	 *     subroutine DWCHN  (NDERIV,U,F)          DWPRO
	 *
	 *     subroutine DWPRO  (NDERIV,U,V,W)        DPASCL */
	/*     subroutine DWQUO  (NDERIV,U,V,W)        DPASCL
	 *
	 *     subroutine DPASCL (N   ,C)              None
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *                   Dependencies between program units
	 *
	 *     The progran units are DWATAN,DWSUM,DWLOG,DWCHN,DWPRO,DPASCL
	 *     DWATAN has calls into        DWSUM,DWLOG,DWCHN,DWPRO
	 *     DWSUM has calls into               DWLOG,DWCHN,DWPRO
	 *     DWLOG has calls into                     DWCHN
	 *     DWCHN has calls into                           DWPRO
	 *     DWPRO has calls into                                 DPASCL
	 *     DPASCL has no calls
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 * */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *
	 *     COMPUTE..              Y5=ATAN(U5)    and derivs w.r.t. T
	 * */
	Y5[1] = atan( U5[1] );
	if (n5 == 0)
		return;
 
	/*     deriv of Y w.r.t. U IS  1./(1. + U**2)
	 *     START BY CONSTRUCTING 1.+U**2 AND ITS derivs IN S1().
	 * */
	S1[1] = 1.0e0 + SQ(U5[1]);
	ns = n5 - 1;
	if (ns == 0)
		goto L_52;
	S1[2] = U5[1] + U5[1];
	if (ns == 1)
		goto L_52;
	S1[3] = 2.0e0;
	if (ns == 2)
		goto L_52;
	for (i = 3; i <= ns; i++)
	{
		S1[i + 1] = 0.0e0;
	}
 
	/*     NOW S1() = 1.+U**2 and derivs w.r.t. U .
	 *     COMPUTE 1./S1 and derivs w.r.t. U.  STORE RESULT STARTING IN Y(2)
	 * */
L_52:
	dwpwri( ns, -1, s1, &Y5[2] );
 
	/*     Convert Y from derivs w.r.t. U TO derivs w.r.t. T */
	dwchn( n5, u5, y5 );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwasin(
long n16,
double u16[],
double y16[])
{
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U16 = &u16[0] - 1;
	double *const Y16 = &y16[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTES..        Y = ASIN(U) and derivs w.r.t. T
	 * */
 
	Y16[1] = asin( U16[1] );
	if (n16 != 0)
		dwacsi( n16, u16, y16, FALSE );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwacos(
long n16,
double u16[],
double y16[])
{
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U16 = &u16[0] - 1;
	double *const Y16 = &y16[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTES..        Y = ACOS(U) and derivs w.r.t. T
	 * */
 
	Y16[1] = acos( U16[1] );
	if (n16 != 0)
		dwacsi( n16, u16, y16, TRUE );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwacsi(
long n16,
double u16[],
double y16[],
LOGICAL32 acosin)
{
	long int i, ns;
	double s1[NMAXP1], s2[NMAXP1];
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const S2 = &s2[0] - 1;
	double *const U16 = &u16[0] - 1;
	double *const Y16 = &y16[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*      Common code for DWACOS and DWASIN  -- ACOSIN - .true. for DWACOS */
 
 
 
	/*     Deriv of Y w.r.t. U is  (+,-)1.0/sqrt(1.0 - U**2)
	 *     Start by constructing 1.0 - U**2 and its derivs in S1().
	 * */
	S1[1] = 1.0e0 - SQ(U16[1]);
	if (S1[1] == 0.0e0)
	{
		/*                                     Error condition. */
		if (acosin)
		{
			ermsg( "DWACOS", 1, 0, "Deriv of ACOS(x) is infinite at x = -1 or +1"
			 , '.' );
		}
		else
		{
			ermsg( "DWASIN", 1, 0, "Deriv of ASIN(x) is infinite at x = -1 or +1"
			 , '.' );
		}
		return;
	}
 
	ns = n16 - 1;
	if (ns == 0)
		goto L_66;
	S1[2] = -2.0e0*U16[1];
	if (ns == 1)
		goto L_66;
	S1[3] = -2.0e0;
	if (ns == 2)
		goto L_66;
	for (i = 3; i <= ns; i++)
	{
		S1[i + 1] = 0.0e0;
	}
 
	/*     Now S1() = 1.0 - U**2 and derivs w.r.t. U.
	 *     Compute S2() = sqrt(1.0 - U**2) and derivs w.r.t. U.
	 *     Then change sign if doing Arc Cosine.
	 * */
L_66:
	;
	dwsqrt( ns, s1, s2 );
	if (acosin)
		dwpro1( ns, -1.0e0, s2, s2 );
 
	/*     Compute 1.0/S2 and derivs w.r.t. U.  Store result starting in Y(2)
	 * */
	dwpwri( ns, -1, s2, &Y16[2] );
 
	/*     Convert Y from derivs w.r.t. U to derivs w.r.t. T */
	dwchn( n16, u16, y16 );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwatn2(
long n9,
double y9[],
double x9[],
double a9[])
{
	long int i, nm1, np1;
	double big, s1[NMAXP1], s2[NMAXP1], s3[NMAXP1], s4[NMAXP1], xx,
	 yy;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const A9 = &a9[0] - 1;
	double *const S1 = &s1[0] - 1;
	double *const S2 = &s2[0] - 1;
	double *const S3 = &s3[0] - 1;
	double *const S4 = &s4[0] - 1;
	double *const X9 = &x9[0] - 1;
	double *const Y9 = &y9[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTES..        A = ATAN2(Y,X) = ATAN(Y/X) and derivs w.r.t. T
	 * */
 
	A9[1] = atan2( Y9[1], X9[1] );
	switch (IARITHIF(n9 - 1))
	{
		case -1: goto L_90;
		case  0: goto L_92;
		case  1: goto L_94;
	}
L_90:
	return;
	/*                            SPECIAL FOR N9 = 1 */
L_92:
	;
	big = fmax( fabs( X9[1] ), fabs( Y9[1] ) );
	yy = Y9[1]/big;
	xx = X9[1]/big;
	A9[2] = (xx*(Y9[2]/big) - yy*(X9[2]/big))/(SQ(xx) + SQ(yy));
	return;
	/*                            GENERAL CASE    N9 .ge. 2 */
L_94:
	;
	np1 = n9 + 1;
	big = fmax( fabs( X9[1] ), fabs( Y9[1] ) );
	for (i = 1; i <= np1; i++)
	{
		S1[i] = X9[i]/big;
		S2[i] = Y9[i]/big;
	}
	nm1 = n9 - 1;
	dwpro( nm1, s1, &S2[2], s3 );
	dwpro( nm1, s2, &S1[2], s4 );
	dwdif( nm1, s3, s4, s3 );
	dwpro( nm1, s1, s1, s1 );
	dwpro( nm1, s2, s2, s2 );
	dwsum( nm1, s1, s2, s1 );
	dwquo( nm1, s3, s1, &A9[2] );
	return;
} /* end of function */
 
void /*FUNCTION*/ dwsum(
long nderiv,
double u[],
double v[],
double w[])
{
	long int i, np1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U = &u[0] - 1;
	double *const V = &v[0] - 1;
	double *const W = &w[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              W=U+V      and derivs w.r.t. T
	 * */
 
	np1 = nderiv + 1;
	for (i = 1; i <= np1; i++)
	{
		W[i] = U[i] + V[i];
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwdif(
long n2,
double u2[],
double v2[],
double w2[])
{
	long int i, np1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U2 = &u2[0] - 1;
	double *const V2 = &v2[0] - 1;
	double *const W2 = &w2[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              W2=U2-V2   and derivs w.r.t. T */
 
	np1 = n2 + 1;
	for (i = 1; i <= np1; i++)
	{
		W2[i] = U2[i] - V2[i];
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwsqrt(
long n15,
double u15[],
double y15[])
{
	long int i;
	double fac, s1[NMAXP1], scale, sqrtu;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const U15 = &u15[0] - 1;
	double *const Y15 = &y15[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..        Y= SQRT(U)      and derivs w.r.t. T
	 * */
 
	sqrtu = sqrt( U15[1] );
	if (n15 == 0)
		goto L_152;
	if (sqrtu == 0.0e0)
	{
		ermsg( "DWSQRT", 2, 0, "Deriv of sqrt(x) is infinite at x = 0"
		 , '.' );
		for (i = 2; i <= (n15 + 1); i++)
		{
			Y15[i] = 0.0e0;
		}
		return;
	}
	if (n15 > 1)
		goto L_154;
	Y15[2] = U15[2]/(sqrtu + sqrtu);
L_152:
	Y15[1] = sqrtu;
	return;
	/*                            GENERAL CASE FOR N .ge. 2 */
L_154:
	;
	scale = 1.0e0/U15[1];
	Y15[1] = 1.0e0;
	S1[1] = 1.0e0;
	fac = 0.5e0;
	for (i = 1; i <= n15; i++)
	{
		Y15[i + 1] = Y15[i]*fac;
		fac -= 1.0e0;
		S1[i + 1] = U15[i + 1]*scale;
	}
	dwchn( n15, s1, y15 );
	Y15[1] = sqrtu;
	for (i = 1; i <= n15; i++)
	{
		Y15[i + 1] *= sqrtu;
	}
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * */
void /*FUNCTION*/ dwexp(
long n4,
double u4[],
double y4[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U4 = &u4[0] - 1;
	double *const Y4 = &y4[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y4=EXP(U4)     and derivs w.r.t. T
	 * */
 
	Y4[1] = exp( U4[1] );
	if (n4 == 0)
		return;
	for (i = 1; i <= n4; i++)
	{
		Y4[i + 1] = Y4[i];
	}
	dwchn( n4, u4, y4 );
	return;
} /* end of function */
 
 
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwsin(
long n7,
double u7[],
double y7[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=SIN(U7) and derivs w.r.t. T
	 * */
 
	Y7[1] = sin( U7[1] );
	if (n7 == 0)
		return;
	Y7[2] = cos( U7[1] );
	if (n7 == 1)
	{
		Y7[2] *= U7[2];
	}
	else
	{
		for (i = 2; i <= n7; i++)
		{
			Y7[i + 1] = -Y7[i - 1];
		}
		dwchn( n7, u7, y7 );
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwcos(
long n7,
double u7[],
double y7[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=COS(U7)      and derivs w.r.t. T
	 * */
 
	Y7[1] = cos( U7[1] );
	if (n7 == 0)
		return;
	Y7[2] = -sin( U7[1] );
	if (n7 == 1)
	{
		Y7[2] *= U7[2];
	}
	else
	{
		for (i = 2; i <= n7; i++)
		{
			Y7[i + 1] = -Y7[i - 1];
		}
		dwchn( n7, u7, y7 );
	}
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwtan(
long n7,
double u7[],
double y7[])
{
	long int i, n7m1;
	double cs, s1[NMAXP1], sn;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=TAN(U7)      and derivs w.r.t. T
	 *     The first deriv is 1/cos(u)**2
	 * */
 
	if (n7 == 0)
	{
		Y7[1] = tan( U7[1] );
		return;
	}
	sn = sin( U7[1] );
	cs = cos( U7[1] );
	Y7[1] = sn/cs;
 
	/*           Compute Cos(U) and its derivs w.r.t. U in S1(2..N+1)
	 * */
	S1[2] = cs;
	S1[3] = -sn;
	for (i = 4; i <= (n7 + 1); i++)
	{
		S1[i] = -S1[i - 2];
	}
	n7m1 = n7 - 1;
	/*                                       Convert to derivs w.r.t. t */
	dwchn( n7m1, u7, &S1[2] );
	/*                               Compute Cos(U)**2 & derivs w.r.t. t */
	dwpro( n7m1, &S1[2], &S1[2], &S1[2] );
	/*                          Divide first deriv of U by Cos(U)**2,
	 *                          both with derivs w.r.t. t */
	dwquo( n7m1, &U7[2], &S1[2], &Y7[2] );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwsinh(
long n7,
double u7[],
double y7[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=SINH(U7) and derivs w.r.t. T
	 * */
 
	Y7[1] = sinh( U7[1] );
	if (n7 == 0)
		return;
	Y7[2] = cosh( U7[1] );
	if (n7 == 1)
	{
		Y7[2] *= U7[2];
	}
	else
	{
		for (i = 2; i <= n7; i++)
		{
			Y7[i + 1] = Y7[i - 1];
		}
		dwchn( n7, u7, y7 );
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwcosh(
long n7,
double u7[],
double y7[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=COSH(U7)      and derivs w.r.t. T
	 * */
 
	Y7[1] = cosh( U7[1] );
	if (n7 == 0)
		return;
	Y7[2] = sinh( U7[1] );
	if (n7 == 1)
	{
		Y7[2] *= U7[2];
	}
	else
	{
		for (i = 2; i <= n7; i++)
		{
			Y7[i + 1] = Y7[i - 1];
		}
		dwchn( n7, u7, y7 );
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwtanh(
long n7,
double u7[],
double y7[])
{
	long int i, n7m1;
	double ch, s1[NMAXP1], sh;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const U7 = &u7[0] - 1;
	double *const Y7 = &y7[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y7=TANH(U7)      and derivs w.r.t. T
	 *     The first deriv is 1/cosh(u)**2
	 * */
 
	if (n7 == 0)
	{
		Y7[1] = tanh( U7[1] );
		return;
	}
	sh = sinh( U7[1] );
	ch = cosh( U7[1] );
	Y7[1] = sh/ch;
 
	/*           Compute Cosh(U) and its derivs w.r.t. U in S1(2..N+1)
	 * */
	S1[2] = ch;
	S1[3] = sh;
	for (i = 4; i <= (n7 + 1); i++)
	{
		S1[i] = S1[i - 2];
	}
	n7m1 = n7 - 1;
	/*                                       Convert to derivs w.r.t. t */
	dwchn( n7m1, u7, &S1[2] );
	/*                               Compute Cosh(U)**2 & derivs w.r.t. t */
	dwpro( n7m1, &S1[2], &S1[2], &S1[2] );
	/*                          Divide first deriv of U by Cosh(U)**2,
	 *                          both with derivs w.r.t. t */
	dwquo( n7m1, &U7[2], &S1[2], &Y7[2] );
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwset(
long n10,
double uval,
double uder,
double u10[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U10 = &u10[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     INITIALIZE THE ARRAY U10()..  SET VALUE=UVAL, 1-ST DERIV = UDER,
	 *                                   AND HIGHER derivs = ZERO */
 
	switch (IARITHIF(n10 - 1))
	{
		case -1: goto L_104;
		case  0: goto L_102;
		case  1: goto L_100;
	}
L_100:
	for (i = 2; i <= n10; i++)
	{
		U10[i + 1] = 0.0e0;
	}
L_102:
	U10[2] = uder;
L_104:
	U10[1] = uval;
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwsum1(
long n11,
double c11,
double u11[],
double y11[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U11 = &u11[0] - 1;
	double *const Y11 = &y11[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..        Y=C+U      WHERE C IS A SCALAR
	 * */
 
	Y11[1] = c11 + U11[1];
	for (i = 1; i <= n11; i++)
	{
		Y11[i + 1] = U11[i + 1];
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwdif1(
long n12,
double c12,
double u12[],
double y12[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U12 = &u12[0] - 1;
	double *const Y12 = &y12[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..        Y=C-U      WHERE C IS A SCALAR
	 * */
 
	Y12[1] = c12 - U12[1];
	for (i = 1; i <= n12; i++)
	{
		Y12[i + 1] = -U12[i + 1];
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwpro1(
long n13,
double c13,
double u13[],
double y13[])
{
	long int i;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U13 = &u13[0] - 1;
	double *const Y13 = &y13[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..        Y=C*U      WHERE C IS A SCALAR
	 * */
 
	for (i = 1; i <= (n13 + 1); i++)
	{
		Y13[i] = c13*U13[i];
	}
	return;
} /* end of function */
 
 
 
void /*FUNCTION*/ dwquo1(
long n14,
double c14,
double u14[],
double y14[])
{
	long int i;
	double s1[NMAXP1];
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const S1 = &s1[0] - 1;
	double *const U14 = &u14[0] - 1;
	double *const Y14 = &y14[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..        Y=C/U      WHERE C IS A SCALAR
	 * */
 
	if (U14[1] == 0.0e0)
	{
		ermsg( "DWQUO1", 3, 0, "Zero divisor.", '.' );
		return;
	}
	S1[1] = c14;
	for (i = 2; i <= (n14 + 1); i++)
	{
		S1[i] = 0.0e0;
	}
	dwquo( n14, s1, u14, y14 );
	return;
} /* end of function */
 
void /*FUNCTION*/ dwlog(
long nderiv,
double u[],
double y[])
{
	long int ii;
	double fac, uinv;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U = &u[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     C. L. LAWSON, JPL, 1971 NOV 19
	 *
	 *     COMPUTE..              Y= LOG BASE E OF U   and derivs w.r.t. T
	 *     ERROR STOP IN this subr IF U(1) .le. 0.
	 * */
 
	Y[1] = log( U[1] );
	if (nderiv <= 1)
	{
		if (nderiv == 1)
			Y[2] = U[2]/U[1];
		return;
	}
	uinv = 1.0e0/U[1];
	Y[2] = uinv;
	fac = -uinv;
	for (ii = 2; ii <= nderiv; ii++)
	{
		Y[ii + 1] = Y[ii]*fac;
		fac -= uinv;
	}
 
	/*     Y() NOW CONTAINS VALUE and derivs w.r.t. U
	 *     USE CHAIN RULE TO convert TO derivs w.r.t. T
	 * */
	dwchn( nderiv, u, y );
	return;
} /* end of function */
 
void /*FUNCTION*/ dwpwri(
long nderiv,
long mpwr,
double u[],
double y[])
{
	LOGICAL32 short_;
	long int i, ii, ii1, ii2, j, m;
	double d, fac, uinv;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U = &u[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..              Y = U**MPWR  and derivs w.r.t. T
	 *     MPWR is an integer, POS.,NEG.,OR ZERO.
	 *     MPWR does not depend ON T.
	 *     U may depend on T
	 *     Issues an error message if both (U(1) .eq. 0.) and (MPWR .lt. 0)
	 *     If MPWR .eq. 0 then set Y(1) = 1. and all derivs = 0.
	 * */
 
	ii2 = nderiv;
	short_ = FALSE;
	m = mpwr;
	switch (IARITHIF(m))
	{
		case -1: goto L_110;
		case  0: goto L_35;
		case  1: goto L_45;
	}
	/*                                      HERE MPWR .eq. 0 */
L_35:
	Y[1] = 1.0e0;
	if (nderiv <= 0)
		return;
	for (j = 1; j <= nderiv; j++)
	{
		Y[j + 1] = 0.0e0;
	}
	return;
	/*                                      HERE MPWR IS POSITIVE */
L_45:
	if (U[1] != 0.0e0)
		goto L_50;
	Y[1] = 0.0e0;
	if (nderiv == 0)
		return;
	if (m <= nderiv)
		goto L_46;
	ii = 1;
	goto L_130;
 
L_46:
	for (i = 1; i <= nderiv; i++)
	{
		Y[i + 1] = 0.0e0;
	}
	fac = 1.0e0;
	d = 0.0e0;
	for (i = 1; i <= m; i++)
	{
		d += 1.0e0;
		fac *= d;
	}
	Y[m + 1] = fac;
	goto L_150;
 
L_50:
	if (m >= nderiv)
		goto L_112;
	ii2 = m;
	short_ = TRUE;
	goto L_112;
 
	/*                                      HERE MPWR .lt 0 */
L_110:
	;
	if (U[1] == 0.0e0)
	{
		ierm1( "DWPWRI", 4, 0, "U**M is infinite when U = 0. and M < 0"
		 , "M", m, '.' );
		for (i = 1; i <= (nderiv + 1); i++)
		{
			Y[i] = 0.0e0;
		}
		return;
	}
L_112:
	;
	Y[1] = powi(U[1],m);
	if (nderiv == 0)
		return;
	uinv = 1.0e0/U[1];
	fac = uinv*m;
	ii1 = 1;
	for (ii = ii1; ii <= ii2; ii++)
	{
		Y[ii + 1] = Y[ii]*fac;
		fac -= uinv;
	}
	if (!short_)
		goto L_150;
	ii = ii2 + 1;
 
	/*                            SET HIGHER derivs TO ZERO.
	 * */
L_130:
	;
	for (j = ii; j <= nderiv; j++)
	{
		Y[j + 1] = 0.0e0;
	}
 
	/*     Y() NOW CONTAINS VALUE and derivs w.r.t. U
	 *     USE CHAIN RULE TO convert TO derivs w.r.t. T
	 * */
L_150:
	dwchn( nderiv, u, y );
	return;
} /* end of function */
 
void /*FUNCTION*/ dwchn(
long nderiv,
double u[],
double y[])
{
	long int i, l, np1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U = &u[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     Implements the chain rule.
	 *     Given values of y(u) and its derivs with respect to u in Y(), and
	 *     u(x) and its derivs with respect to x in U(), this subr replaces
	 *     the contents of Y() with y(u(x)) and its derivs with respect to x.
	 *
	 *     NDERIV                 HIGHEST ORDER DERIVATIVE
	 *
	 *     (U(I),I=1,NDERIV+1)    INPUT.. value of u and derivs w.r.t. x
	 *
	 *     (Y(I),I=1,NDERIV+1)    INPUT.. value of y and derivs w.r.t. u
	 *                            OUTPUT.. (Y(I+1),I=1,NDERIV) will be
	 *                                     replaced by derivs w.r.t. x */
 
	if (nderiv == 0)
		return;
	if (U[2] != 1.)
		goto L_20;
	/*                             U(2) .eq. 1.,  See if higher derivs are 0. */
	if (nderiv == 1)
		return;
	for (i = 2; i <= nderiv; i++)
	{
		if (U[i + 1] != 0.)
			goto L_50;
	}
	return;
	/*                                   Test if all derivs of U are 0. */
L_20:
	for (i = 1; i <= nderiv; i++)
	{
		if (U[i + 1] != 0.)
			goto L_50;
	}
 
	for (i = 1; i <= nderiv; i++)
	{
		Y[i + 1] = 0.;
	}
	return;
 
	/*         Here for the general case when U is not T and not constant.
	 * */
L_50:
	np1 = nderiv + 1;
	for (l = 0; l <= (nderiv - 1); l++)
	{
		dwpro( l, &Y[np1 - l], &U[2], &Y[np1 - l] );
	}
	return;
} /* end of function */
 
void /*FUNCTION*/ dwrchn(
long nderiv,
double u[],
double y[])
{
	long int l, np1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const U = &u[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     Implements the "reverse" chain rule.
	 *     Given values of y(u(x)) and its derivs with respect to x in Y(),
	 *     and u(x) and its derivs with respect to x in U(), this subr replac
	 *     the contents of Y() with y(u) and its derivs with respect to u.
	 *     Requires u'(x) .ne. 0.
	 *
	 *     Note that this subr can be used to compute a representation of
	 *     the inverse function of a given function.  This transformation
	 *     is called "reversion" of a power series.  To do this let y() be
	 *     the inverse function of u() in a neighborhood of a point, x0.
	 *     Thus y(u(x)) = x for all x in a neighborhood of x0.
	 *     Then the value of y() and its derivs with respect to x, evaluated
	 *     at x0 are (x0, 1.0, 0.0, ..., 0.0).
	 *     If Y() contains these values on entry, and U() contains u(x) and
	 *     its derivs w.r.t. x, evaluated at x0, then on return Y() will
	 *     contain y(u) and its derivs w.r.t. u, evaluated at u0 = u(x0).
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *     NDERIV  [in]  Highest order derivative to be considered.
	 *
	 *     (U(I),I=1,NDERIV+1)  [in]  Contains the value of u(x) and its
	 *           first NDERIV derivatives with respect to x, evaluated at x0.
	 *           Require U(2) .ne. 0.
	 *
	 *     (Y(I),I=1,NDERIV+1)  [inout]  On entry, Y() must contain y(u(x))
	 *           and its first NDERIV derivatives w.r.t. x, evaluated at x0.
	 *           On return, Y() will contain y(u) and its first NDERIV
	 *           derivatives w.r.t. u, evaluated at u0 = u(x0).
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	np1 = nderiv + 1;
 
	if (U[2] == 0.0e0 && np1 >= 2)
	{
		ermsg( "DWRCHN", 9, 0, "U(2) is zero.", '.' );
		return;
	}
 
	for (l = 2; l <= np1; l++)
	{
		dwquo( np1 - l, &Y[l], &U[2], &Y[l] );
	}
	return;
} /* end of function */
 
		/* PARAMETER translations */
#define	NCOEF	(1 + (NMAX*(NMAX + 1))/2)
		/* end of PARAMETER translations */
 
	/* COMMON translations */
struct t_dwcom {
	double c[NCOEF];
	}	dwcom;
	/* end of COMMON translations */
void /*FUNCTION*/ dwpro(
long nderiv,
double u[],
double v[],
double w[])
{
	long int i, id2, imid, ip1, j, jc, np1;
	double temp;
	static LOGICAL32 first = TRUE;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const C = &dwcom.c[0] - 1;
	double *const U = &u[0] - 1;
	double *const V = &v[0] - 1;
	double *const W = &w[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*                      COMPUTE W(1)=U(1)*V(1) AND DERIVATIVES .
	 *     NDERIV           HIGHEST ORDER DERIVATIVE TO BE COMPUTED
	 *                      NDERIV .ge. 0
	 *     (U(I),I=1,NDERIV+1)    INPUT ARRAY..
	 *                                       U(1)= VALUE
	 *                                       U(I+1)= I-TH DERIVATIVE OF U(1)
	 *     (V(I),I=1,NDERIV+1)    INPUT ARRAY..      SAME FORMAT AS U().
	 *
	 *     (W(I),I=1,NDERIV+1)    OUTPUT ARRAY..
	 *                                            W(1)= U(1)*V(1)
	 *                                            W(I+1)=Ith deriv of W(1)
	 *     It is permissible for W() to occupy the same storage locations as
	 *     U() and/or V().
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	 *     NMAX        Setting NMAX in the parameter statement determines
	 *           the highest order derivative this program unit will be able
	 *           to handle.  The dimension of the internal saved array C()
	 *           will be set as a function of NMAX.
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	if (first)
	{
		dpascl( NMAX, dwcom.c );
		first = FALSE;
	}
	if (nderiv > NMAX)
	{
		ierm1( "DWPRO", 5, 0, "Dimension NMAX in DWATAN, DWSUM, & DWPRO must be .ge. NDERIV"
		 , "NMAX", NMAX, ',' );
		ierv1( "NDERIV", nderiv, '.' );
		return;
	}
	np1 = nderiv + 1;
	/*     JC = (NDERIV*(NDERIV-1))/2
	 *     DO 20 I=NP1,1,-1
	 *         TEMP=0.0D0
	 *         IP1=I+1
	 *              DO 10 J=1,I
	 *              TEMP = TEMP + U(J)*V(IP1-J)*C(JC+J)
	 *  10     continue
	 *         W(I) = TEMP
	 *         JC=JC- I+2
	 *  20 continue
	 *
	 *     The following code does the same as the above commented-out
	 *     code but reduces the number of multiplies.
	 *     Treats the cases of NDERIV = 0, 1, 2, 3, and 4 special for
	 *     efficiency, since it is expected that most usage will involve
	 *     small values of NDERIV.  In particular the chain rule subroutine,
	 *     _WCHN, will call this subr with a sequence of values of NDERIV
	 *     going down to 0.
	 *     Treats NDERIV > 4 in a general way, but takes account of
	 *     the fact that the C() terms in the "do 10" loop above are
	 *     symmetric about the middle term and the first and last term
	 *     are each = 1.
	 * */
	switch (np1)
	{
		case 1: goto L_41;
		case 2: goto L_42;
		case 3: goto L_43;
		case 4: goto L_44;
		case 5: goto L_45;
	}
 
	/*     Fortran 77 specifies that a Computed Go To drops through is the
	 *     index is out of range.  Thus we arrive here if NP1 < 1 or > 5.
	 *     NP1 < 1 would be an error.  We choose not to use time to test for
	 *     it however.
	 *     NP1 > 5 is valid. In that case we do the following loop for I
	 *     running down from NP1 to 6, and then do the special statements
	 *     for 5, 4, 3, 2, and 1.
	 * */
	jc = (nderiv*(nderiv - 1))/2;
	for (i = np1; i >= 6; i--)
	{
		temp = U[1]*V[i] + U[i]*V[1];
		ip1 = i + 1;
		id2 = i/2;
		for (j = 2; j <= id2; j++)
		{
			temp += C[jc + j]*(U[j]*V[ip1 - j] + U[ip1 - j]*V[j]);
		}
		if (2*id2 == i)
		{
			W[i] = temp;
		}
		else
		{
			imid = id2 + 1;
			W[i] = temp + C[jc + imid]*U[imid]*V[imid];
		}
		jc += -i + 2;
	}
 
L_45:
	W[5] = U[1]*V[5] + 4.0e0*(U[2]*V[4] + U[4]*V[2]) + 6.0e0*U[3]*
	 V[3] + U[5]*V[1];
L_44:
	W[4] = U[1]*V[4] + 3.0e0*(U[2]*V[3] + U[3]*V[2]) + U[4]*V[1];
L_43:
	W[3] = U[1]*V[3] + 2.0e0*U[2]*V[2] + U[3]*V[1];
L_42:
	W[2] = U[1]*V[2] + U[2]*V[1];
L_41:
	W[1] = U[1]*V[1];
	return;
} /* end of function */
/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void /*FUNCTION*/ dwquo(
long nderiv,
double u[],
double v[],
double w[])
{
	long int i, id2, imid, ip1, j, jc, np1;
	double fac, temp;
	static LOGICAL32 first = TRUE;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const C = &dwcom.c[0] - 1;
	double *const U = &u[0] - 1;
	double *const V = &v[0] - 1;
	double *const W = &w[0] - 1;
		/* end of OFFSET VECTORS */
 
 
	/*     COMPUTE..          W = U / V  and derivs w.r.t. T
	 *
	 *     V() must be distinct in storage from W(), but U() can be the same
	 *     array as W().
	 *
	 *     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	if (first)
	{
		dpascl( NMAX, dwcom.c );
		first = FALSE;
	}
	if (nderiv > NMAX)
	{
		ierm1( "DWQUO", 6, 0, "Dimension NMAX in DWATAN, DWSUM, & DWPRO must be .ge. NDERIV"
		 , "NMAX", NMAX, ',' );
		ierv1( "NDERIV", nderiv, '.' );
		return;
	}
 
	if (V[1] == 0.0e0)
	{
		ermsg( "DWQUO", 7, 0, "Zero divisor.", '.' );
		return;
	}
 
	fac = 1.0e0/V[1];
	W[1] = U[1]*fac;
	np1 = nderiv + 1;
	jc = 0;
	/*         DO 40 I=2,NP1
	 *            TEMP = U(I)
	 *            IP1=I+1
	 *            DO 30 J=2,I
	 *               TEMP = TEMP - V(J)*W(IP1-J)*C(JC+J)
	 *  30        CONTINUE
	 *            W(I) = TEMP * FAC
	 *            JC=JC + I-1
	 *  40     CONTINUE */
	for (i = 2; i <= np1; i++)
	{
		temp = U[i] - W[1]*V[i];
		ip1 = i + 1;
		id2 = i/2;
		for (j = 2; j <= id2; j++)
		{
			temp += -C[jc + j]*(W[j]*V[ip1 - j] + W[ip1 - j]*V[j]);
		}
		if (2*id2 != i)
		{
			imid = id2 + 1;
			temp += -C[jc + imid]*W[imid]*V[imid];
		}
		W[i] = temp*fac;
		jc += i - 1;
	}
	return;
} /* end of function */
 
void /*FUNCTION*/ dpascl(
long n,
double c[])
{
	long int i, j, k, l;
	static LOGICAL32 done = FALSE;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const C = &c[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*        C.L.LAWSON,JPL, 1969 DEC 10
	 *
	 *     N                      MAXIMUM ORDER DERIVATIVE TO BE
	 *                            COMPUTED USING W-ARITHMETIC
	 *
	 *     (C(I),I=1,NC)          FIRST N+1 ROWS OF PASCAL TRIANGLE PACKED
	 *                            WITH 1-ST DIAGONAL OMITTED AFTER 1-ST ROW.
	 *                            NC= (N*(N+1)/2) + 1
	 *     EXAMPLE..    IF N=3 then TRIANGLE IS       1
	 *                                              1    1
	 *                                            1   2    1
	 *                                          1   3    3   1
	 *
	 *     WHICH WILL BE STORED AS.. 1,1,2,1,3,3,1
	 * */
	/*     -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	if (done)
		return;
	done = TRUE;
	if (n < 0)
	{
		ierm1( "DPASCL", 8, 0, "Require N .ge. 0", "N", n, '.' );
		return;
	}
	C[1] = 1.0e0;
	if (n == 0)
		return;
	C[2] = 1.0e0;
	if (n == 1)
		return;
	k = 3;
	for (i = 1; i <= (n - 1); i++)
	{
		l = i + 1;
		for (j = 1; j <= i; j++)
		{
			C[k] = C[k - l] + C[k - l + 1];
			k += 1;
		}
		C[k] = 1.0e0;
		k += 1;
	}
	return;
} /* end of function */
 
