/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:06 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "drotm.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	TWO	2.0e0
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ drotm(
long n,
double dx[],
long incx,
double dy[],
long incy,
double dparam[])
{
	long int _d_l, _d_m, _do0, _do1, _do2, _do3, _do4, _do5, i, kx,
	 ky, nsteps;
	double dflag, dh11, dh12, dh21, dh22, w, z;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Dparam = &dparam[0] - 1;
	double *const Dx = &dx[0] - 1;
	double *const Dy = &dy[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2006-06-07 DROTM  Krogh  Removed arithmetic ifs
	 *>> 1994-10-20 DROTM  Krogh  Changes to use M77CON
	 *>> 1994-04-29 DROTM  CLL Edited to make DP and SP codes similar.
	 *>> 1985-08-02 DROTM  Lawson  Initial code.
	 *
	 *     APPLY THE MODIFIED GIVENS TRANSFORMATION, H, TO THE 2 BY N MATRIX
	 *
	 *     (DX**T) , WHERE **T INDICATES TRANSPOSE. THE ELEMENTS OF DX ARE IN
	 *     (DY**T)
	 *
	 *     DX(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
	 *     LX = (-INCX)*N, AND SIMILARLY FOR SY USING LY AND INCY.
	 *     WITH DPARAM(1)=DFLAG, H HAS ONE OF THE FOLLOWING FORMS..
	 *
	 *     DFLAG=-1.D0     DFLAG=0.D0        DFLAG=1.D0     DFLAG=-2.D0
	 *
	 *       (DH11  DH12)    (1.D0  DH12)    (DH11  1.D0)    (1.D0  0.D0)
	 *     H=(          )    (          )    (          )    (          )
	 *       (DH21  DH22),   (DH21  1.D0),   (-1.D0 DH22),   (0.D0  1.D0).
	 *     SEE DROTMG FOR A DESCRIPTION OF DATA STORAGE IN DPARAM.
	 *     -----------------------------------------------------------------
	 *--D replaces "?": ?ROTM
	 *     ----------------------------------------------------------------- */
	/*     -----------------------------------------------------------------
	 * */
	dflag = Dparam[1];
	if ((n <= 0) || (dflag + TWO == ZERO))
		return;
	if ((incx != incy) || (incx < 0))
	{
		kx = 1;
		ky = 1;
		if (incx < 0)
			kx = 1 + (1 - n)*incx;
		if (incy < 0)
			ky = 1 + (1 - n)*incy;
 
		if (dflag == 0.e0)
		{
			dh12 = Dparam[4];
			dh21 = Dparam[3];
			for (i = 1; i <= n; i++)
			{
				w = Dx[kx];
				z = Dy[ky];
				Dx[kx] = w + z*dh12;
				Dy[ky] = w*dh21 + z;
				kx += incx;
				ky += incy;
			}
		}
		else if (dflag > 0.e0)
		{
			dh11 = Dparam[2];
			dh22 = Dparam[5];
			for (i = 1; i <= n; i++)
			{
				w = Dx[kx];
				z = Dy[ky];
				Dx[kx] = w*dh11 + z;
				Dy[ky] = -w + dh22*z;
				kx += incx;
				ky += incy;
			}
		}
		else
		{
			dh11 = Dparam[2];
			dh12 = Dparam[4];
			dh21 = Dparam[3];
			dh22 = Dparam[5];
			for (i = 1; i <= n; i++)
			{
				w = Dx[kx];
				z = Dy[ky];
				Dx[kx] = w*dh11 + z*dh12;
				Dy[ky] = w*dh21 + z*dh22;
				kx += incx;
				ky += incy;
			}
		}
	}
	else
	{
		nsteps = n*incx;
		if (dflag == 0.e0)
		{
			dh12 = Dparam[4];
			dh21 = Dparam[3];
			for (i = 1, _do0=DOCNT(i,nsteps,_do1 = incx); _do0 > 0; i += _do1, _do0--)
			{
				w = Dx[i];
				z = Dy[i];
				Dx[i] = w + z*dh12;
				Dy[i] = w*dh21 + z;
			}
		}
		else if (dflag > 0.e0)
		{
			dh11 = Dparam[2];
			dh22 = Dparam[5];
			for (i = 1, _do2=DOCNT(i,nsteps,_do3 = incx); _do2 > 0; i += _do3, _do2--)
			{
				w = Dx[i];
				z = Dy[i];
				Dx[i] = w*dh11 + z;
				Dy[i] = -w + dh22*z;
			}
		}
		else
		{
			dh11 = Dparam[2];
			dh12 = Dparam[4];
			dh21 = Dparam[3];
			dh22 = Dparam[5];
			for (i = 1, _do4=DOCNT(i,nsteps,_do5 = incx); _do4 > 0; i += _do5, _do4--)
			{
				w = Dx[i];
				z = Dy[i];
				Dx[i] = w*dh11 + z*dh12;
				Dy[i] = w*dh21 + z*dh22;
			}
		}
	}
	return;
} /* end of function */
 
