/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:18 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_srangv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_srangv.h"
/*     program DRSRANGV
 *>> 2001-05-22 DRSRANGV Krogh Minor change for making .f90 version.
 *>> 1994-10-19 DRSRANGV Krogh  Changes to use M77CON
 *>> 1987-12-09 DRSRANGV Lawson  Initial Code.
 *--S replaces "?": DR?RANGV, ?RANGV
 *        Demonstration driver for the Gaussian random vector generator,
 *     SRANGV.
 *     C. L. Lawson & S. Y. Chiu, JPL, Apr 1987.
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	NMAX	3
		/* end of PARAMETER translations */
 
 
int main( )
{
	LOGICAL32 havec;
	long int _n, i, ierr, j, n, nsampl, _i, _r;
	float x[NMAX];
	static float a[NMAX][NMAX], u[NMAX];
	static int _aini = 1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const U = &u[0] - 1;
	float *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static float _itmp0[] = {1.0e0,2.0e0,3.0e0};
		for (j = 1, _r = 0; j <= NMAX; j++)
		{
			U[j] = _itmp0[_r++];
			}
		}
		{ static float _itmp1[] = {0.05e0,0.02e0,0.01e0};
		for (j = 1, _r = 0; j <= NMAX; j++)
		{
			a[j - 1][0] = _itmp1[_r++];
			}
		}
		{ static float _itmp2[] = {0.02e0,0.07e0,-0.03e0};
		for (j = 1, _r = 0; j <= NMAX; j++)
		{
			a[j - 1][1] = _itmp2[_r++];
			}
		}
		{ static float _itmp3[] = {0.01e0,-0.03e0,0.06e0};
		for (j = 1, _r = 0; j <= NMAX; j++)
		{
			a[j - 1][2] = _itmp3[_r++];
			}
		}
		_aini = 0;
	}
 
	/*     ------------------------------------------------------------------ */
	n = NMAX;
	nsampl = 20;
	havec = FALSE;
	printf(" Pseudorandom vectors computed by SRANGV\n \n");
	for (i = 1; i <= nsampl; i++)
	{
		srangv( (float*)a, NMAX, n, u, x, &havec, &ierr );
		if (ierr != 0)
		{
			printf(" %3ld%6ld\n", n, ierr);
		}
		else
		{
			printf(" %3ld", i);
			printf("     ");
			for(_n=0L; _n < sizeof(x)/sizeof(float); _n++)
				printf("%12.3f", x[_n]);
			printf("\n");
		}
	}
	exit(0);
} /* end of function */
 
