/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:15 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_scpltk s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include "p_scpltk.h"
/*     DRSCPLTK
 *>> 2001-06-17 DRSCPLTK Krogh Changed T computation.
 *>> 1996-05-30 DRSCPLTK Krogh Added external statement.
 *>> 1994-10-19 DRSCPLTK Krogh  Changes to use M77CON
 *>> 1994-09-01 DRSCPLTK WVS Moved formats to top for C conversion
 *>> 1994-08-09 DRSCPLTK WVS set up for CHGTYP
 *>> 1992-04-29 DRSCPLTK CAO Replaced '1' in format.
 *>> 1991-11-19 DRSCPLTK CLL
 *>> 1987-12-09 DRSCPLTK Lawson  Initial Code.
 *--S replaces "?": DR?CPLTK, ?CPLTK, ?CPLTE
 *
 *     DEMONSTRATION DRIVER FOR ELLIPTIC INTEGRALS.
 *
 *     EVALUATE THE LEGENDRE'S RELATION:
 *     Z = PI/2 - (K*E1 + K1*E - K*K1) = 0
 * */
 
int main( )
{
	long int _l0, i;
	float e, e1, k, k1, t, tprime, z;
	static float pi2 = 1.5707963267948966192313217e0;
	static float em[6]={0.001e0,.2e0,.4e0,.6e0,.8e0,.999e0};
	static float zero = 0.e0;
	static float one = 1.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Em = &em[0] - 1;
		/* end of OFFSET VECTORS */
 
 
 
	tprime = FLT_EPSILON;
	t = one - tprime;
 
	printf("     EM         SCPLTK(EM)       SCPLTE(EM)        Z\n \n");
	printf("  %6.3f  %15.8f  %15.8f   \n", zero, scpltk( zero ), scplte( zero ));
 
	for (i = 1; i <= 6; i++)
	{
		k = scpltk( Em[i] );
		k1 = scpltk( 1 - Em[i] );
		e = scplte( Em[i] );
		e1 = scplte( 1 - Em[i] );
		z = pi2 - (k*e1 + k1*e - k*k1);
		printf("  %6.3f  %15.8f  %15.8f   %10.2g\n", Em[i], k, e, z);
	}
	k = scpltk( t );
	k1 = scpltk( tprime );
	e = scplte( t );
	e1 = scplte( tprime );
	z = pi2 - (k*e1 + k1*e - k*k1);
	printf("   T      %15.8f  %15.8f   %10.2g\n", k, e, z);
	printf("  %6.3f         INFINITY  %15.8f   \n", one, scplte( one ));
	printf("\n  TPRIME = Machine epsilon =%10.2e\n", tprime);
	printf("  T = 1. - TPRIME\n");
 
	exit(0);
} /* end of function */
 
