/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:14 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_sblas1 s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_sblas1.h"
/*     program DRSBLAS1
 *>> 1996-06-18 DRSBLAS1 Krogh  Minor format change for C conversion.
 *>> 1996-05-28 DRSBLAS1 Krogh Added external statement.
 *>> 1994-10-19 DRSBLAS1 Krogh  Changes to use M77CON
 *>> 1992-03-24 DRSBLAS1 CLL Removed reference to REAL() function.
 *>> 1991-12-02 DRSBLAS1 CLL
 *>> 1991-07-25 DRSBLAS1 CLL
 *>> 1987-12-09 DRBLAS1  Lawson  Initial Code.
 *
 *     Demonstrate usage of SAXPY, SCOPY, and SDOT from the BLAS
 *     by computing
 *     (1) p = A * b              using SDOT
 *     (2) q = A * b              using SCOPY & SAXPY
 *     (3) r = (A Transposed) * p using SDOT
 *     (4) S = A * E              using SDOT
 *     ------------------------------------------------------------------
 *--S replaces "?": DR?BLAS1, ?AXPY, ?COPY, ?DOT
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	M2	5
#define	M3	10
#define	M4	12
#define	N2	2
#define	N3	3
#define	N4	4
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, j, _i, _r;
	float p[M2], q[M2], r[M3], s[M4][M2];
	static float a[M3][M2], b[M3], e[M4][M3], zero[1];
	static int _aini = 1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const B = &b[0] - 1;
	float *const P = &p[0] - 1;
	float *const Q = &q[0] - 1;
	float *const R = &r[0] - 1;
	float *const Zero = &zero[0] - 1;
		/* end of OFFSET VECTORS */
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		Zero[1] = 0.0e0;
		{ static float _itmp0[] = {2.0e0,-4.0e0,3.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			a[j - 1][0] = _itmp0[_r++];
			}
		}
		{ static float _itmp1[] = {-5.0e0,-2.0e0,6.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			a[j - 1][1] = _itmp1[_r++];
			}
		}
		{ static float _itmp2[] = {7.0e0,-3.0e0,5.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			B[j] = _itmp2[_r++];
			}
		}
		{ static float _itmp3[] = {-4.0e0,2.0e0,3.0e0,-6.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][0] = _itmp3[_r++];
			}
		}
		{ static float _itmp4[] = {7.0e0,5.0e0,-6.0e0,-3.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][1] = _itmp4[_r++];
			}
		}
		{ static float _itmp5[] = {3.0e0,4.0e0,-2.0e0,5.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][2] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}
 
 
	/*     ---------------------------------------------------------------
	 *
	 *                                  1. p = A * b using SDOT
	 * */
	for (i = 1; i <= N2; i++)
	{
		P[i] = sdot( N3, &a[0][i - 1], M2, b, 1 );
	}
 
	/*                                  2. q = A * b using SCOPY and SAXPY
	 * */
	scopy( N2, zero, 0, q, 1 );
	for (j = 1; j <= N3; j++)
	{
		saxpy( N2, B[j], &a[j - 1][0], 1, q, 1 );
	}
 
	/*                                  3. r = (A Transposed) * p using SDOT
	 * */
	for (j = 1; j <= N3; j++)
	{
		R[j] = sdot( N2, &a[j - 1][0], 1, p, 1 );
	}
 
	/*                                  4. S = A * E using SDOT
	 * */
	for (i = 1; i <= N2; i++)
	{
		for (j = 1; j <= N4; j++)
		{
			s[j - 1][i - 1] = sdot( N3, &a[0][i - 1], M2, &e[j - 1][0],
			 1 );
		}
	}
 
	printf("DRSBLAS1..  Demo driver for SAXPY, SCOPY, and SDOT\n");
	printf("\n P() =        ");
	for (j = 1; j <= N2; j++)
	{
		printf("%8.1f", P[j]);
	}
	printf("\n");
	printf("\n Q() =        ");
	for (j = 1; j <= N2; j++)
	{
		printf("%8.1f", Q[j]);
	}
	printf("\n");
	printf("\n R() =        ");
	for (j = 1; j <= N3; j++)
	{
		printf("%8.1f", R[j]);
	}
	printf("\n");
	printf("\n S(,) = \n");
	for (i = 1; i <= N2; i++)
	{
		printf("   Row %2ld", i);
		printf("     ");
		for (j = 1; j <= N4; j++)
		{
			printf("%8.1f", s[j - 1][i - 1]);
		}
		printf("\n");
	}
	exit(0);
} /* end of function */
 
