/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:12 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_drft1 s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_drft1.h"
/*     program DRDRFT1
 *>> 1996-06-05 DRDRFT1 Krogh Fixes for conversion to C.
 *>> 1996-05-28 DRDRFT1 Krogh Moved formats up.
 *>> 1994-10-19 DRDRFT1 Krogh  Changes to use M77CON
 *>> 1994-08-09 DRDRFT1 WVS Removed '0' from format
 *>> 1992-04-22 DRDRFT1 CAO, commented program statement
 *>> 1989-05-07 DRDRFT1 FTK, CLL
 *>> 1989-05-04 DRDRFT1 FTK, CLL
 *     Demo driver for DRFT1 -- One-dimensional real Fourier transform
 *     ------------------------------------------------------------------
 *--D replaces "?": DR?RFT1, ?RFT1
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	FOUR	4.e0
#define	M	7
#define	N	128
#define	N2	(N/2)
#define	N4	(N/4)
#define	ONE	1.e0
#define	P1	.1e0
#define	P3	.3e0
#define	PI	3.1415926535897932384e0
#define	RTWO	1.4142135623730950488e0
#define	TWOPI	(2.e0*PI)
#define	ZERO	0.e0
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, k, klast, ms;
	double deltat, f[N], pin, s[N4 - 1], sig, t, tb;
	static double ttime = 25.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const F = &f[0] - 1;
	double *const S = &s[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*      parameter (N = 2**M) */
	/*     ------------------------------------------------------------------ */
	klast = N2 - 1;
	deltat = ttime/(double)( N );
	t = ZERO;
	/*                Get sine table for use in getting sigma factors */
	ms = -1;
	drft1( f, 'A', M, &ms, s );
	pin = PI/(double)( N );
	for (k = 1; k <= klast; k++)
	{
		t += deltat;
		tb = ttime - t;
		/*                               Get sigma factor */
		if (k > N4)
		{
			sig = S[N2 - k];
		}
		else if (k < N4)
		{
			sig = S[k];
		}
		else
		{
			sig = ONE;
		}
		sig /= pin*(double)( N - 2*k );
 
		/*                         Compute F and apply sigma factors
		 * */
		F[k + 1] = sig*(sin( TWOPI*(t + P1) ) + FOUR*cos( TWOPI*(RTWO*
		 t + P3) ));
		F[N - k + 1] = sig*(sin( TWOPI*(tb + P1) ) + FOUR*cos( TWOPI*
		 (RTWO*tb + P3) ));
	}
	F[1] = ZERO;
	t += deltat;
	F[N2 + 1] = sin( TWOPI*(t + P1) ) + FOUR*cos( TWOPI*(RTWO*t +
	 P3) );
	drft1( f, 'A', M, &ms, s );
	printf("\n Transform for K=21 to 41 using sigma factors\n");
	for (k = 21; k <= 41; k += 3)
	{
		printf(" K=%3ld TO%3ld", k, k + 2);
		for (i = 2*k - 1; i <= (2*k + 4); i++)
		{
			printf("%12.2e", F[i]);
		}
		printf("\n");
	}
	exit(0);
} /* end of function */
 
