/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:09 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dcpltk s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include "p_dcpltk.h"
/*     DRDCPLTK
 *>> 2001-06-17 DRDCPLTK Krogh Changed T computation.
 *>> 1996-05-30 DRDCPLTK Krogh Added external statement.
 *>> 1994-10-19 DRDCPLTK Krogh  Changes to use M77CON
 *>> 1994-09-01 DRDCPLTK WVS Moved formats to top for C conversion
 *>> 1994-08-09 DRDCPLTK WVS set up for CHGTYP
 *>> 1992-04-29 DRDCPLTK CAO Replaced '1' in format.
 *>> 1991-11-19 DRDCPLTK CLL
 *>> 1987-12-09 DRDCPLTK Lawson  Initial Code.
 *--D replaces "?": DR?CPLTK, ?CPLTK, ?CPLTE
 *
 *     DEMONSTRATION DRIVER FOR ELLIPTIC INTEGRALS.
 *
 *     EVALUATE THE LEGENDRE'S RELATION:
 *     Z = PI/2 - (K*E1 + K1*E - K*K1) = 0
 * */
 
int main( )
{
	long int _l0, i;
	double e, e1, k, k1, t, tprime, z;
	static double pi2 = 1.5707963267948966192313217e0;
	static double em[6]={0.001e0,.2e0,.4e0,.6e0,.8e0,.999e0};
	static double zero = 0.e0;
	static double one = 1.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Em = &em[0] - 1;
		/* end of OFFSET VECTORS */
 
 
 
	tprime = DBL_EPSILON;
	t = one - tprime;
 
	printf("     EM         DCPLTK(EM)       DCPLTE(EM)        Z\n \n");
	printf("  %6.3f  %15.8f  %15.8f   \n", zero, dcpltk( zero ), dcplte( zero ));
 
	for (i = 1; i <= 6; i++)
	{
		k = dcpltk( Em[i] );
		k1 = dcpltk( 1 - Em[i] );
		e = dcplte( Em[i] );
		e1 = dcplte( 1 - Em[i] );
		z = pi2 - (k*e1 + k1*e - k*k1);
		printf("  %6.3f  %15.8f  %15.8f   %10.2g\n", Em[i], k, e, z);
	}
	k = dcpltk( t );
	k1 = dcpltk( tprime );
	e = dcplte( t );
	e1 = dcplte( tprime );
	z = pi2 - (k*e1 + k1*e - k*k1);
	printf("   T      %15.8f  %15.8f   %10.2g\n", k, e, z);
	printf("  %6.3f         INFINITY  %15.8f   \n", one, dcplte( one ));
	printf("\n  TPRIME = Machine epsilon =%10.2e\n", tprime);
	printf("  T = 1. - TPRIME\n");
 
	exit(0);
} /* end of function */
 
