/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:08 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dblas1 s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_dblas1.h"
/*     program DRDBLAS1
 *>> 1996-06-18 DRDBLAS1 Krogh  Minor format change for C conversion.
 *>> 1996-05-28 DRDBLAS1 Krogh Added external statement.
 *>> 1994-10-19 DRDBLAS1 Krogh  Changes to use M77CON
 *>> 1992-03-24 DRDBLAS1 CLL Removed reference to DBLE() function.
 *>> 1991-12-02 DRDBLAS1 CLL
 *>> 1991-07-25 DRDBLAS1 CLL
 *>> 1987-12-09 DRBLAS1  Lawson  Initial Code.
 *
 *     Demonstrate usage of DAXPY, DCOPY, and DDOT from the BLAS
 *     by computing
 *     (1) p = A * b              using DDOT
 *     (2) q = A * b              using DCOPY & DAXPY
 *     (3) r = (A Transposed) * p using DDOT
 *     (4) S = A * E              using DDOT
 *     ------------------------------------------------------------------
 *--D replaces "?": DR?BLAS1, ?AXPY, ?COPY, ?DOT
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	M2	5
#define	M3	10
#define	M4	12
#define	N2	2
#define	N3	3
#define	N4	4
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, j, _i, _r;
	double p[M2], q[M2], r[M3], s[M4][M2];
	static double a[M3][M2], b[M3], e[M4][M3], zero[1];
	static int _aini = 1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const B = &b[0] - 1;
	double *const P = &p[0] - 1;
	double *const Q = &q[0] - 1;
	double *const R = &r[0] - 1;
	double *const Zero = &zero[0] - 1;
		/* end of OFFSET VECTORS */
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		Zero[1] = 0.0e0;
		{ static double _itmp0[] = {2.0e0,-4.0e0,3.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			a[j - 1][0] = _itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {-5.0e0,-2.0e0,6.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			a[j - 1][1] = _itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {7.0e0,-3.0e0,5.0e0};
		for (j = 1, _r = 0; j <= N3; j++)
		{
			B[j] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {-4.0e0,2.0e0,3.0e0,-6.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][0] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {7.0e0,5.0e0,-6.0e0,-3.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {3.0e0,4.0e0,-2.0e0,5.0e0};
		for (j = 1, _r = 0; j <= N4; j++)
		{
			e[j - 1][2] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}
 
 
	/*     ---------------------------------------------------------------
	 *
	 *                                  1. p = A * b using DDOT
	 * */
	for (i = 1; i <= N2; i++)
	{
		P[i] = ddot( N3, &a[0][i - 1], M2, b, 1 );
	}
 
	/*                                  2. q = A * b using DCOPY and DAXPY
	 * */
	dcopy( N2, zero, 0, q, 1 );
	for (j = 1; j <= N3; j++)
	{
		daxpy( N2, B[j], &a[j - 1][0], 1, q, 1 );
	}
 
	/*                                  3. r = (A Transposed) * p using DDOT
	 * */
	for (j = 1; j <= N3; j++)
	{
		R[j] = ddot( N2, &a[j - 1][0], 1, p, 1 );
	}
 
	/*                                  4. S = A * E using DDOT
	 * */
	for (i = 1; i <= N2; i++)
	{
		for (j = 1; j <= N4; j++)
		{
			s[j - 1][i - 1] = ddot( N3, &a[0][i - 1], M2, &e[j - 1][0],
			 1 );
		}
	}
 
	printf("DRDBLAS1..  Demo driver for DAXPY, DCOPY, and DDOT\n");
	printf("\n P() =        ");
	for (j = 1; j <= N2; j++)
	{
		printf("%8.1f", P[j]);
	}
	printf("\n");
	printf("\n Q() =        ");
	for (j = 1; j <= N2; j++)
	{
		printf("%8.1f", Q[j]);
	}
	printf("\n");
	printf("\n R() =        ");
	for (j = 1; j <= N3; j++)
	{
		printf("%8.1f", R[j]);
	}
	printf("\n");
	printf("\n S(,) = \n");
	for (i = 1; i <= N2; i++)
	{
		printf("   Row %2ld", i);
		printf("     ");
		for (j = 1; j <= N4; j++)
		{
			printf("%8.1f", s[j - 1][i - 1]);
		}
		printf("\n");
	}
	exit(0);
} /* end of function */
 
