/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:03 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "delpii.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	PIHALF	1.570796326794896619231322e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ delpii(
double phi,
double k2,
double alpha2,
double *p,
long *ierr)
{
	double a, b, c, r, rf, s, s2;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>>1996-05-02 DELPII Krogh  Fixed "max" for C conversion.
	 *>>1994-10-20 DELPII Krogh  Changes to use M77CON
	 *>>1991-10-10 DELPII WV Snyder JPL Original code.
	 * ----------------------------------------------------------------------
	 *        COMPUTES REAL ELLIPTIC INTEGRAL OF THE THIRD KIND
	 * ---------------------------------------------------------------------- */
	/*        IERR = 0..3, AS FOR DRJVAL AND DRFVAL
	 *        IERR = 4 IF ABS(PHI) > PI/2.
	 *
	 *--D replaces "?": ?ELPII, ?ERM1, ?RFVAL, ?RJVAL
	 * -------------------- */
	/* ---------------------------------------------------------------------- */
	if (fabs( phi ) > PIHALF)
	{
		*ierr = 4;
		derm1( "DELPII", 4, 0, "ABS(PHI) > PI/2", "PHI", phi, '.' );
		return;
	}
 
	s = sin( phi );
	c = cos( phi );
	a = c*c;
	s2 = s*s;
	b = 1.0 - k2*s2;
	s2 *= alpha2;
	r = 1.0 - s2;
	c = fmax( a, fmax( b, r ) );
	a *= c;
	b *= c;
	r *= c;
 
	drjval( a, b, c, r, p, ierr );
	if (*ierr == 0)
	{
		drfval( a, b, c, &rf, ierr );
		*p = sqrt( c )*s*((s2*c**p)/3.0 + rf);
	}
	return;
 
} /* end of function */
 
