      subroutine DBI1K1 (x, BI1, BK1, want, status)
c Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
c ALL RIGHTS RESERVED.
c Based on Government Sponsored Research NAS7-03001.
C>> 1998-10-29 DBI1K1 Krogh  Moved external statement up for mangle.
c>> 1996-04-27 DBI1K1 Krogh  Changes to use .C. and C%%.
C>> 1995-11-28 DBI1K1 Krogh  Changes to simplify conversion to C.
C>> 1995-11-03 DBI1K1 Krogh  Removed blanks in numbers for C conversion.
C>> 1994-10-20 DBI1K1 Krogh  Changes to use M77CON
C>> 1994-04-19 DBI1K1 CLL Edited to make DP & SP files similar.
C>> 1990-09-25 DBI1K1 WV Snyder JPL Use Fullerton codes from CMLIB
C--D replaces "?": ?BI1K1, ?CSEVL, ?ERM1, ?INITS
c
c     Compute hyperbolic Bessel functions I1 and K1.
c     Approximations originally produced by Wayne Fullerton, LASL.
c
c     *****     Formal Arguments     ***********************************
c
c X [in] is the argument at which the functions are to be evaluated.
c BI1, BK1 [out] are the function values.
c WANT [integer,in] indicates the functions to be computed, and their
c                   scaling:
c     ABS(WANT) =
c        1 means compute I1(X)
c        2 means compute K1(X)
c        3 means compute both of I1(X) and K1(X)
c     WANT < 0 means compute EXP(-X)*I1(X) and/or EXP(X)*K1(X).
c     WANT=0 or ABS(WANT) > 3 causes an error message to be produced.
c STATUS [integer,out] indicates the outcome:
c        0 means normal computation,
c        1 means K1(X) is zero due to underflow,
c        < 0 means an error occurred:
c           -1 means WANT=0 or ABS(WANT)>3,
c           -2 means X was so big that I1(X) overflowed,
c           -3 means X was zero or negative and K1(X) is to be computed,
c           -4 means X was so small K1(X) overflows.
c     Negative values of STATUS are produced when the error message
c     processor is called with LEVEL=0; positive values of STATUS are
c     accompanied by LEVEL=-2.  See the description of the error message
c     handler for a description of the error level effects.
c     If status = -2 then BI1 = the largest representable number;
c     if status = -3 or -4 then BK1 = the largest representable number.
c     ------------------------------------------------------------------
      double precision X, BI1, BK1
      integer WANT, STATUS
c
c     *****     External References     ********************************
c
      external DCSEVL, IERM1, DINITS, D1MACH, DERM1
      double precision D1MACH, DCSEVL
c
c     *****     Local Variables     ************************************
c
      double precision BI1CS(17), AI1CS(46), AI12CS(69)
      double precision  BK1CS(16), AK1CS(38), AK12CS(33)
      double precision EXP10, EXPM10, LSQ2PI, LSQPI2
      parameter (EXP10 = (+.2202646579480671651695790D+5))
C     EXP10 = EXP(10)
      parameter (EXPM10 = (+.4539992976248485153559152D-4))
C     EXPM10 = EXP(-10)
      parameter (LSQ2PI = (+.9189385332046727417803296D+0))
C     LSQ2PI = LOG(SQRT (2 PI))
      parameter (LSQPI2 = (+.2257913526447274323630975D+0))
C     LSQPI2 = LOG(SQRT(PI / 2))
      double precision I1NS, XIN, XKN, Y, Z
      double precision BOUNDK, XIMAX, XIMIN, XISML, XKMAX, XKMIN, XKSML
      integer NTI1, NTAI1, NTAI12, NTK1, NTAK1, NTAK12
      save NTI1, NTAI1, NTAI12, XIMAX, XIMIN, XISML
      save BOUNDK, NTK1, NTAK1, NTAK12, XKMAX, XKMIN, XKSML
c
c     *****     Data     ***********************************************
c
C SERIES FOR BI1        ON THE INTERVAL  0.          TO  9.00000D+00
C                                        WITH WEIGHTED ERROR   1.44D-32
C                                         LOG WEIGHTED ERROR  31.84
C                               SIGNIFICANT FIGURES REQUIRED  31.45
C                                    DECIMAL PLACES REQUIRED  32.46
C
      DATA BI1CS / -.19717132610998597316138503218149D-2,
     *   +.40734887667546480608155393652014D+0,
     *   +.34838994299959455866245037783787D-1,
     *   +.15453945563001236038598401058489D-2,
     *   +.41888521098377784129458832004120D-4,
     *   +.76490267648362114741959703966069D-6,
     *   +.10042493924741178689179808037238D-7,
     *   +.99322077919238106481371298054863D-10,
     *   +.76638017918447637275200171681349D-12,
     *   +.47414189238167394980388091948160D-14,
     *   +.24041144040745181799863172032000D-16,
     *   +.10171505007093713649121100799999D-18,
     *   +.36450935657866949458491733333333D-21,
     *   +.11205749502562039344810666666666D-23,
     *   +.29875441934468088832000000000000D-26,
     *   +.69732310939194709333333333333333D-29,
     *   +.14367948220620800000000000000000D-31 /
C
C SERIES FOR AI1        ON THE INTERVAL  1.25000D-01 TO  3.33333D-01
C                                        WITH WEIGHTED ERROR   2.81D-32
C                                         LOG WEIGHTED ERROR  31.55
C                               SIGNIFICANT FIGURES REQUIRED  29.93
C                                    DECIMAL PLACES REQUIRED  32.38
C
c++ Save data by elements if ~.C.
      DATA AI1CS(1) /   -.2846744181881478674100372468307D-1 /
      DATA AI1CS(2) /   -.1922953231443220651044448774979D-1 /
      DATA AI1CS(3) /   -.6115185857943788982256249917785D-3 /
      DATA AI1CS(4) /   -.2069971253350227708882823777979D-4 /
      DATA AI1CS(5) /   +.8585619145810725565536944673138D-5 /
      DATA AI1CS(6) /   +.1049498246711590862517453997860D-5 /
      DATA AI1CS(7) /   -.2918338918447902202093432326697D-6 /
      DATA AI1CS(8) /   -.1559378146631739000160680969077D-7 /
      DATA AI1CS(9) /   +.1318012367144944705525302873909D-7 /
      DATA AI1CS(10) /  -.1448423418183078317639134467815D-8 /
      DATA AI1CS(11) /  -.2908512243993142094825040993010D-9 /
      DATA AI1CS(12) /  +.1266388917875382387311159690403D-9 /
      DATA AI1CS(13) /  -.1664947772919220670624178398580D-10 /
      DATA AI1CS(14) /  -.1666653644609432976095937154999D-11 /
      DATA AI1CS(15) /  +.1242602414290768265232168472017D-11 /
      DATA AI1CS(16) /  -.2731549379672432397251461428633D-12 /
      DATA AI1CS(17) /  +.2023947881645803780700262688981D-13 /
      DATA AI1CS(18) /  +.7307950018116883636198698126123D-14 /
      DATA AI1CS(19) /  -.3332905634404674943813778617133D-14 /
      DATA AI1CS(20) /  +.7175346558512953743542254665670D-15 /
      DATA AI1CS(21) /  -.6982530324796256355850629223656D-16 /
      DATA AI1CS(22) /  -.1299944201562760760060446080587D-16 /
      DATA AI1CS(23) /  +.8120942864242798892054678342860D-17 /
      DATA AI1CS(24) /  -.2194016207410736898156266643783D-17 /
      DATA AI1CS(25) /  +.3630516170029654848279860932334D-18 /
      DATA AI1CS(26) /  -.1695139772439104166306866790399D-19 /
      DATA AI1CS(27) /  -.1288184829897907807116882538222D-19 /
      DATA AI1CS(28) /  +.5694428604967052780109991073109D-20 /
      DATA AI1CS(29) /  -.1459597009090480056545509900287D-20 /
      DATA AI1CS(30) /  +.2514546010675717314084691334485D-21 /
      DATA AI1CS(31) /  -.1844758883139124818160400029013D-22 /
      DATA AI1CS(32) /  -.6339760596227948641928609791999D-23 /
      DATA AI1CS(33) /  +.3461441102031011111108146626560D-23 /
      DATA AI1CS(34) /  -.1017062335371393547596541023573D-23 /
      DATA AI1CS(35) /  +.2149877147090431445962500778666D-24 /
      DATA AI1CS(36) /  -.3045252425238676401746206173866D-25 /
      DATA AI1CS(37) /  +.5238082144721285982177634986666D-27 /
      DATA AI1CS(38) /  +.1443583107089382446416789503999D-26 /
      DATA AI1CS(39) /  -.6121302074890042733200670719999D-27 /
      DATA AI1CS(40) /  +.1700011117467818418349189802666D-27 /
      DATA AI1CS(41) /  -.3596589107984244158535215786666D-28 /
      DATA AI1CS(42) /  +.5448178578948418576650513066666D-29 /
      DATA AI1CS(43) /  -.2731831789689084989162564266666D-30 /
      DATA AI1CS(44) /  -.1858905021708600715771903999999D-30 /
      DATA AI1CS(45) /  +.9212682974513933441127765333333D-31 /
      DATA AI1CS(46) /  -.2813835155653561106370833066666D-31 /
C
C SERIES FOR AI12       ON THE INTERVAL  0.          TO  1.25000D-01
C                                        WITH WEIGHTED ERROR   1.83D-32
C                                         LOG WEIGHTED ERROR  31.74
C                               SIGNIFICANT FIGURES REQUIRED  29.97
C                                    DECIMAL PLACES REQUIRED  32.66
C
c++ Save data by elements if ~.C.
      DATA AI12CS(1) /   +.2857623501828012047449845948469D-1 /
      DATA AI12CS(2) /   -.9761097491361468407765164457302D-2 /
      DATA AI12CS(3) /   -.1105889387626237162912569212775D-3 /
      DATA AI12CS(4) /   -.3882564808877690393456544776274D-5 /
      DATA AI12CS(5) /   -.2512236237870208925294520022121D-6 /
      DATA AI12CS(6) /   -.2631468846889519506837052365232D-7 /
      DATA AI12CS(7) /   -.3835380385964237022045006787968D-8 /
      DATA AI12CS(8) /   -.5589743462196583806868112522229D-9 /
      DATA AI12CS(9) /   -.1897495812350541234498925033238D-10 /
      DATA AI12CS(10) /  +.3252603583015488238555080679949D-10 /
      DATA AI12CS(11) /  +.1412580743661378133163366332846D-10 /
      DATA AI12CS(12) /  +.2035628544147089507224526136840D-11 /
      DATA AI12CS(13) /  -.7198551776245908512092589890446D-12 /
      DATA AI12CS(14) /  -.4083551111092197318228499639691D-12 /
      DATA AI12CS(15) /  -.2101541842772664313019845727462D-13 /
      DATA AI12CS(16) /  +.4272440016711951354297788336997D-13 /
      DATA AI12CS(17) /  +.1042027698412880276417414499948D-13 /
      DATA AI12CS(18) /  -.3814403072437007804767072535396D-14 /
      DATA AI12CS(19) /  -.1880354775510782448512734533963D-14 /
      DATA AI12CS(20) /  +.3308202310920928282731903352405D-15 /
      DATA AI12CS(21) /  +.2962628997645950139068546542052D-15 /
      DATA AI12CS(22) /  -.3209525921993423958778373532887D-16 /
      DATA AI12CS(23) /  -.4650305368489358325571282818979D-16 /
      DATA AI12CS(24) /  +.4414348323071707949946113759641D-17 /
      DATA AI12CS(25) /  +.7517296310842104805425458080295D-17 /
      DATA AI12CS(26) /  -.9314178867326883375684847845157D-18 /
      DATA AI12CS(27) /  -.1242193275194890956116784488697D-17 /
      DATA AI12CS(28) /  +.2414276719454848469005153902176D-18 /
      DATA AI12CS(29) /  +.2026944384053285178971922860692D-18 /
      DATA AI12CS(30) /  -.6394267188269097787043919886811D-19 /
      DATA AI12CS(31) /  -.3049812452373095896084884503571D-19 /
      DATA AI12CS(32) /  +.1612841851651480225134622307691D-19 /
      DATA AI12CS(33) /  +.3560913964309925054510270904620D-20 /
      DATA AI12CS(34) /  -.3752017947936439079666828003246D-20 /
      DATA AI12CS(35) /  -.5787037427074799345951982310741D-22 /
      DATA AI12CS(36) /  +.7759997511648161961982369632092D-21 /
      DATA AI12CS(37) /  -.1452790897202233394064459874085D-21 /
      DATA AI12CS(38) /  -.1318225286739036702121922753374D-21 /
      DATA AI12CS(39) /  +.6116654862903070701879991331717D-22 /
      DATA AI12CS(40) /  +.1376279762427126427730243383634D-22 /
      DATA AI12CS(41) /  -.1690837689959347884919839382306D-22 /
      DATA AI12CS(42) /  +.1430596088595433153987201085385D-23 /
      DATA AI12CS(43) /  +.3409557828090594020405367729902D-23 /
      DATA AI12CS(44) /  -.1309457666270760227845738726424D-23 /
      DATA AI12CS(45) /  -.3940706411240257436093521417557D-24 /
      DATA AI12CS(46) /  +.4277137426980876580806166797352D-24 /
      DATA AI12CS(47) /  -.4424634830982606881900283123029D-25 /
      DATA AI12CS(48) /  -.8734113196230714972115309788747D-25 /
      DATA AI12CS(49) /  +.4045401335683533392143404142428D-25 /
      DATA AI12CS(50) /  +.7067100658094689465651607717806D-26 /
      DATA AI12CS(51) /  -.1249463344565105223002864518605D-25 /
      DATA AI12CS(52) /  +.2867392244403437032979483391426D-26 /
      DATA AI12CS(53) /  +.2044292892504292670281779574210D-26 /
      DATA AI12CS(54) /  -.1518636633820462568371346802911D-26 /
      DATA AI12CS(55) /  +.8110181098187575886132279107037D-28 /
      DATA AI12CS(56) /  +.3580379354773586091127173703270D-27 /
      DATA AI12CS(57) /  -.1692929018927902509593057175448D-27 /
      DATA AI12CS(58) /  -.2222902499702427639067758527774D-28 /
      DATA AI12CS(59) /  +.5424535127145969655048600401128D-28 /
      DATA AI12CS(60) /  -.1787068401578018688764912993304D-28 /
      DATA AI12CS(61) /  -.6565479068722814938823929437880D-29 /
      DATA AI12CS(62) /  +.7807013165061145280922067706839D-29 /
      DATA AI12CS(63) /  -.1816595260668979717379333152221D-29 /
      DATA AI12CS(64) /  -.1287704952660084820376875598959D-29 /
      DATA AI12CS(65) /  +.1114548172988164547413709273694D-29 /
      DATA AI12CS(66) /  -.1808343145039336939159368876687D-30 /
      DATA AI12CS(67) /  -.2231677718203771952232448228939D-30 /
      DATA AI12CS(68) /  +.1619029596080341510617909803614D-30 /
      DATA AI12CS(69) /  -.1834079908804941413901308439210D-31 /
c
C
C SERIES FOR  BK1         ON THE INTERVAL  0.          TO  4.00000D+00
C                                        WITH WEIGHTED ERROR   9.16D-32
C                                         LOG WEIGHTED ERROR  31.04
C                               SIGNIFICANT FIGURES REQUIRED  30.61
C                                    DECIMAL PLACES REQUIRED  31.64
C
      DATA  BK1CS / +.25300227338947770532531120868533D-1,
     *   -.35315596077654487566723831691801D+0,
     *   -.12261118082265714823479067930042D+0,
     *   -.69757238596398643501812920296083D-2,
     *   -.17302889575130520630176507368979D-3,
     *   -.24334061415659682349600735030164D-5,
     *   -.22133876307347258558315252545126D-7,
     *   -.14114883926335277610958330212608D-9,
     *   -.66669016941993290060853751264373D-12,
     *   -.24274498505193659339263196864853D-14,
     *   -.70238634793862875971783797120000D-17,
     *   -.16543275155100994675491029333333D-19,
     *   -.32338347459944491991893333333333D-22,
     *   -.53312750529265274999466666666666D-25,
     *   -.75130407162157226666666666666666D-28,
     *   -.91550857176541866666666666666666D-31 /
C
C SERIES FOR AK1        ON THE INTERVAL  1.25000D-01 TO  5.00000D-01
C                                        WITH WEIGHTED ERROR   3.07D-32
C                                         LOG WEIGHTED ERROR  31.51
C                               SIGNIFICANT FIGURES REQUIRED  30.71
C                                    DECIMAL PLACES REQUIRED  32.30
C
c++ Save data by elements if ~.C.
      DATA AK1CS(1) /   +.27443134069738829695257666227266D+0 /
      DATA AK1CS(2) /   +.75719899531993678170892378149290D-1 /
      DATA AK1CS(3) /   -.14410515564754061229853116175625D-2 /
      DATA AK1CS(4) /   +.66501169551257479394251385477036D-4 /
      DATA AK1CS(5) /   -.43699847095201407660580845089167D-5 /
      DATA AK1CS(6) /   +.35402774997630526799417139008534D-6 /
      DATA AK1CS(7) /   -.33111637792932920208982688245704D-7 /
      DATA AK1CS(8) /   +.34459775819010534532311499770992D-8 /
      DATA AK1CS(9) /   -.38989323474754271048981937492758D-9 /
      DATA AK1CS(10) /  +.47208197504658356400947449339005D-10 /
      DATA AK1CS(11) /  -.60478356628753562345373591562890D-11 /
      DATA AK1CS(12) /  +.81284948748658747888193837985663D-12 /
      DATA AK1CS(13) /  -.11386945747147891428923915951042D-12 /
      DATA AK1CS(14) /  +.16540358408462282325972948205090D-13 /
      DATA AK1CS(15) /  -.24809025677068848221516010440533D-14 /
      DATA AK1CS(16) /  +.38292378907024096948429227299157D-15 /
      DATA AK1CS(17) /  -.60647341040012418187768210377386D-16 /
      DATA AK1CS(18) /  +.98324256232648616038194004650666D-17 /
      DATA AK1CS(19) /  -.16284168738284380035666620115626D-17 /
      DATA AK1CS(20) /  +.27501536496752623718284120337066D-18 /
      DATA AK1CS(21) /  -.47289666463953250924281069568000D-19 /
      DATA AK1CS(22) /  +.82681500028109932722392050346666D-20 /
      DATA AK1CS(23) /  -.14681405136624956337193964885333D-20 /
      DATA AK1CS(24) /  +.26447639269208245978085894826666D-21 /
      DATA AK1CS(25) /  -.48290157564856387897969868800000D-22 /
      DATA AK1CS(26) /  +.89293020743610130180656332799999D-23 /
      DATA AK1CS(27) /  -.16708397168972517176997751466666D-23 /
      DATA AK1CS(28) /  +.31616456034040694931368618666666D-24 /
      DATA AK1CS(29) /  -.60462055312274989106506410666666D-25 /
      DATA AK1CS(30) /  +.11678798942042732700718421333333D-25 /
      DATA AK1CS(31) /  -.22773741582653996232867840000000D-26 /
      DATA AK1CS(32) /  +.44811097300773675795305813333333D-27 /
      DATA AK1CS(33) /  -.88932884769020194062336000000000D-28 /
      DATA AK1CS(34) /  +.17794680018850275131392000000000D-28 /
      DATA AK1CS(35) /  -.35884555967329095821994666666666D-29 /
      DATA AK1CS(36) /  +.72906290492694257991679999999999D-30 /
      DATA AK1CS(37) /  -.14918449845546227073024000000000D-30 /
      DATA AK1CS(38) /  +.30736573872934276300799999999999D-31 /
C
C SERIES FOR AK12       ON THE INTERVAL  0.          TO  1.25000D-01
C                                        WITH WEIGHTED ERROR   2.41D-32
C                                         LOG WEIGHTED ERROR  31.62
C                               SIGNIFICANT FIGURES REQUIRED  30.25
C                                    DECIMAL PLACES REQUIRED  32.38
C
c++ Save data by elements if ~.C.
      DATA AK12CS(1) /   +.6379308343739001036600488534102D-1 /
      DATA AK12CS(2) /   +.2832887813049720935835030284708D-1 /
      DATA AK12CS(3) /   -.2475370673905250345414545566732D-3 /
      DATA AK12CS(4) /   +.5771972451607248820470976625763D-5 /
      DATA AK12CS(5) /   -.2068939219536548302745533196552D-6 /
      DATA AK12CS(6) /   +.9739983441381804180309213097887D-8 /
      DATA AK12CS(7) /   -.5585336140380624984688895511129D-9 /
      DATA AK12CS(8) /   +.3732996634046185240221212854731D-10 /
      DATA AK12CS(9) /   -.2825051961023225445135065754928D-11 /
      DATA AK12CS(10) /  +.2372019002484144173643496955486D-12 /
      DATA AK12CS(11) /  -.2176677387991753979268301667938D-13 /
      DATA AK12CS(12) /  +.2157914161616032453939562689706D-14 /
      DATA AK12CS(13) /  -.2290196930718269275991551338154D-15 /
      DATA AK12CS(14) /  +.2582885729823274961919939565226D-16 /
      DATA AK12CS(15) /  -.3076752641268463187621098173440D-17 /
      DATA AK12CS(16) /  +.3851487721280491597094896844799D-18 /
      DATA AK12CS(17) /  -.5044794897641528977117282508800D-19 /
      DATA AK12CS(18) /  +.6888673850418544237018292223999D-20 /
      DATA AK12CS(19) /  -.9775041541950118303002132480000D-21 /
      DATA AK12CS(20) /  +.1437416218523836461001659733333D-21 /
      DATA AK12CS(21) /  -.2185059497344347373499733333333D-22 /
      DATA AK12CS(22) /  +.3426245621809220631645388800000D-23 /
      DATA AK12CS(23) /  -.5531064394246408232501248000000D-24 /
      DATA AK12CS(24) /  +.9176601505685995403782826666666D-25 /
      DATA AK12CS(25) /  -.1562287203618024911448746666666D-25 /
      DATA AK12CS(26) /  +.2725419375484333132349439999999D-26 /
      DATA AK12CS(27) /  -.4865674910074827992378026666666D-27 /
      DATA AK12CS(28) /  +.8879388552723502587357866666666D-28 /
      DATA AK12CS(29) /  -.1654585918039257548936533333333D-28 /
      DATA AK12CS(30) /  +.3145111321357848674303999999999D-29 /
      DATA AK12CS(31) /  -.6092998312193127612416000000000D-30 /
      DATA AK12CS(32) /  +.1202021939369815834623999999999D-30 /
      DATA AK12CS(33) /  -.2412930801459408841386666666666D-31 /
c
      data NTI1 /0/
c
c     *****     Statement Functions     ********************************
c
      xin(z) = ximax + 0.5*log(z/(1.0-3.0/(8.0*z))**2)
      xkn(z) = xkmax - 0.5*log(z/(1.0+3.0/(8.0*z))**2)
c
c     *****     Executable Statements     ******************************
c
      if (nti1 .eq. 0) then
         z = 0.1*D1MACH(3)
         boundk = 1.693 - 6.965D-3 * log(z)
         call DINITS (bi1cs, 17, z,   nti1  )
         call DINITS (ai1cs, 46, z, ntai1 )
         call DINITS (ai12cs, 69, z, ntai12)
         call DINITS (bk1cs, 16, z, ntk1  )
         call DINITS (ak1cs, 38, z, ntak1 )
         call DINITS (ak12cs, 33, z, ntak12)
         ximin  = 2.0D0*D1MACH(1)
         xisml  = sqrt (80.0D0*z)
         ximax = log(D1MACH(2)) + lsq2pi
         ximax = xin(xin(ximax))
         xksml = sqrt (40.0D0*z)
         xkmax = -log(D1MACH(1))
         xkmin = exp (max(-xkmax, -log(D1MACH(2))) + 0.01D0)
         xkmax = lsqpi2 + xkmax
         xkmax = xkn(xkn(xkn(xkmax)))
      end if
c
      if (want.eq.0 .or. abs(want).gt.3) then
         call ierm1('DBI1K1',-1,0,'WANT = 0 OR ABS(WANT) > 3','WANT',
     1      want,'.')
         status=-1
         return
      end if
      status = 0
c
c     Compute I1 if requested, or if needed for K1 computation.
c
      y = abs(x)
      if (y .le. 3.0D0) then
         if (abs(want).ne.2 .or. y.le.boundk) then
            if (y .lt. ximin) then
c              if (y .ne. 0.0D0)
c    *           call DERM1('DBI1K1',2,-1,
c    *                'ABS(X) SO SMALL I1 UNDERFLOWS', 'X',x,'.')
               BI1 = 0.0
c              status = 2
            else
               if (y.le.xisml) then
                  i1ns = 0.5D0*x
               else
                  i1ns = x*(0.875D0+DCSEVL(y*y/4.5D0-1.0D0,bi1cs,nti1))
               end if
               if (want.lt.0) then
                  BI1 = exp(-y) * i1ns
               else
                  BI1 = i1ns
               end if
            end if
         end if
      else if (abs(want) .ne. 2) then
         if (y .le. 8.0D0) then
            BI1 = DCSEVL ((48.0D0/y-11.0D0)/5.0D0, ai1cs, ntai1)
         else
            BI1 = DCSEVL (16.0D0/y-1.0D0, ai12cs, ntai12)
         end if
         BI1 = sign((0.375D0 + BI1)/sqrt(y), x)
         if (want .gt. 0) then
            if (y .gt. ximax) then
               call DERM1('DBI1K1',-2,0,'ABS(X) SO BIG I1 OVERFLOWS',
     *              'X', x, '.')
               status = -2
               BI1 = D1MACH(2)
c              y > ximax => y > xkmax
               BK1 = 0.0
               if (x .gt. 0.0) return
            else
               BI1 = (exp(y-10.0d0) * BI1) * exp10
            end if
         end if
      end if
c
c     Compute K1 if requested.
c
      if (abs(want) .gt. 1) then
         if (x .le. 0.0D0) then
            call DERM1('DBI1K1',-3,0,'X IS ZERO OR NEGATIVE','X',x,'.')
            status = -3
            BK1 = D1MACH(2)
         else if (x .le. boundk) then
            if (x .lt. xkmin) then
               call DERM1('DBI1K1',-4,0,
     *              'X IS SO SMALL K1 OVERFLOWS','X', x,'.')
               status = -4
               BK1 = D1MACH(2)
            else
               if (x .le. xksml) then
                  y = 0.D0
               else
                  y = x*x
               end if
               BK1 = log(0.5D0*x)*i1ns + (0.75D0 +
     1            DCSEVL (0.5D0*y-1.0D0,  bk1cs, ntk1))/x
               if (want .lt. 0) BK1 = exp(x) * BK1
            end if
         else
            y = 16.0D0 / x
            if (x .le. 8.0D0) then
               BK1 = DCSEVL ((y-5.0D0)/3.0D0, ak1cs, ntak1)
            else
               BK1 = DCSEVL (y-1.0D0, ak12cs, ntak12)
            end if
            BK1 = (1.25D0 + BK1) / sqrt(x)
            if (want .gt. 0) then
               if (x .gt. xkmax) then
                  call DERM1('DBI1K1',1,-1,'X SO BIG K1 UNDERFLOWS','X',
     1               x,'.')
                  BK1 = 0.0d0
                  status = 1
               else
                  BK1 = (exp(10.0d0-x) * BK1) * expm10
               end if
            end if
         end if
      end if
C
      return
c
      end
