% MATH77.cls -- Fred T. Krogh (fkrogh@mathalacarte.com) Mar. 19, 1995
% PLEASE NOTE -- The author makes no pretense that he knows what he
% has done here.  Macros were changed at random until they appeared
% to work.
% Modifications started with article.cls generated Jan. 20, 1995.
% NO WARRANTY OR GUARANTEES OF ANY KIND.
% Please let me know of any improvements that you make.
%
\typeout{Document Class `MATH77' <25 Jan. 95>.}
%
%%%%%%%%%%%%%%%%%% BEGIN EXAMPLE USAGE %%%%%%%%%%%%%%%%%%%%%%%
% \documentclass[twoside]{MATH77}
% \usepackage{multi77}
% \usepackage[fleqn,reqno,centertags]{amstex}
% \begin{document}
% \begmath ii.j Title   %%% ii=Chapter Number j=section number
% \subsection{Purpose}  %%% Subsections are main subheadings in writeup.
% ...
% \end{document}
%%%%%%%%%%%%%%%%%%% END EXAMPLE USAGE %%%%%%%%%%%%%%%%%%%%%%%
%
%%
%% This is file `article.cls', generated
%% on <1995/1/20> with the docstrip utility (2.2i).
%%
%% The original source files were:
%%
%% classes.dtx  (with options: `article')
%%
%% Copyright 1994 the LaTeX3 project and the individual authors.
%% All rights reserved. For further copyright information see the file
%% legal.txt, and any other copyright indicated in this file.
%%
%% This file is part of the LaTeX2e system.
%% ----------------------------------------
%%
%% This system is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
%%
%%
%% IMPORTANT NOTICE:
%%
%% For error reports in case of UNCHANGED versions see bugs.txt.
%%
%% Please do not request updates from us directly. Distribution is
%% done through Mail-Servers and TeX organizations.
%%
%% You are not allowed to change this file.
%%
%% You are allowed to distribute this file under the condition that
%% it is distributed together with all files mentioned in manifest.txt.
%%
%% If you receive only some of these files from someone, complain!
%%
%% You are NOT ALLOWED to distribute this file alone. You are NOT
%% ALLOWED to take money for the distribution or use of either this
%% file or a changed version, except for a nominal charge for copying
%% etc.
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{MATH77}
              [1995/01/25 v1.2x Standard LaTeX document class]
\newcommand{\@ptsize}{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\newif\if@openbib
\@openbibfalse
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{10pt}{\renewcommand{\@ptsize}{0}}
\DeclareOption{11pt}{\renewcommand{\@ptsize}{1}}
\DeclareOption{12pt}{\renewcommand{\@ptsize}{2}}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{\@openbibtrue}
\ExecuteOptions{letterpaper,10pt,oneside,onecolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand{\baselinestretch}{}
\parskip 5pt plus 1pt minus 1pt \parindent 0pt
\setlength\parskip{5\p@ \@plus 1\p@ minus 1\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand{\topfraction}{.7}
\setcounter{bottomnumber}{1}
\renewcommand{\bottomfraction}{.3}
\setcounter{totalnumber}{3}
\renewcommand{\textfraction}{.2}
\renewcommand{\floatpagefraction}{.5}
\setcounter{dbltopnumber}{2}
\renewcommand{\dbltopfraction}{.7}
\renewcommand{\dblfloatpagefraction}{.5}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markboth {\uppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection.\hskip 1em\relax
        \fi
        ##1}}{}}%
    \def\subsectionmark##1{%
      \markright {%
        \ifnum \c@secnumdepth >\@ne
          \thesubsection\hskip 1em\relax
          \fi
          ##1}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\uppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\hskip 1em\relax
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{\let\@mkboth\@gobbletwo
  \def\@oddhead{}
  \def\@oddfoot{\rm \small \today \hfil \thesecname \hfil
      \thesection --\thepage}
  \def\@evenhead{}
  \def\@evenfoot{\rm \small \thesection --\thepage \hfil
       \thesecname \hfil \today}
  \def\sectionmark##1{}
  \def\subsectionmark##1{}}
\if@titlepage
  \newcommand{\maketitle}{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \let\thanks\relax\let\maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\else
\newcommand{\maketitle}{\par
  \begingroup
    \renewcommand{\thefootnote}{\fnsymbol{footnote}}%
    \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\setcounter{section}{0}
\setcounter{subsection}{0}
\setcounter{secnumdepth}{4}
\renewcommand{\thepart}         {\Roman{part}}
\renewcommand{\thesection}      {}
\renewcommand{\thesubsection}   {\Alph{subsection}.}
\renewcommand{\thesubsubsection}{\thesubsection \arabic{subsubsection}}
\renewcommand{\theparagraph}    {\thesubsubsection.\alph{paragraph}}
\renewcommand{\thesubparagraph} {\theparagraph.\roman{subparagraph}}
\def\intro#1{
\setcounter{subsection}{#1}
\renewcommand{\thesubsection}{1.\arabic{subsection}}
\renewcommand{\thesubsubsection}{\thesubsection.\alph{subsubsection}}}
\def\introalt{
\setcounter{subsection}{0}
\renewcommand{\thesubsection}{\Alph{subsection}.}
\renewcommand{\thesubsubsection}{\thesubsection \arabic{subsubsection}}}
\newcommand{\part}{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \reset@font
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \reset@font
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\def\@endpart{\vfil\newpage
              \if@twoside
                \hbox{}%
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}

\newcommand{\section}{\@startsection {section}{1}{\z@}{0ex plus 0ex minus
0ex}{3ex plus .3ex}{\Large\bf}} %{if\dthesection=2 \fi }}
\newcommand{\subsection}{\@startsection{subsection}{2}{\z@}{1.0ex plus .25ex
 minus .1ex}{.01ex}{\large\bf}}
\newcommand{\subsubsection}{\@startsection{subsubsection}{3}{\z@}{.3ex plus
.1ex minus .1ex}{.01ex}{\normalsize\bf}}
\newcommand{\paragraph}{\@startsection
{paragraph}{4}{\z@}{1ex plus .05ex minus .1ex}{.01ex}{\normalsize\bf}}
\newcommand{\subparagraph}{\@startsection
 {subparagraph}{5}{\z@}{.1ex plus .05ex minus .1ex}{.01ex}{\normalsize\bf}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand{\theenumi}{\arabic{enumi}}
\renewcommand{\theenumii}{\alph{enumii}}
\renewcommand{\theenumiii}{\roman{enumiii}}
\renewcommand{\theenumiv}{\Alph{enumiv}}
\newcommand{\labelenumi}{\theenumi.}
\newcommand{\labelenumii}{(\theenumii)}
\newcommand{\labelenumiii}{\theenumiii.}
\newcommand{\labelenumiv}{\theenumiv.}
\renewcommand{\p@enumii}{\theenumi}
\renewcommand{\p@enumiii}{\theenumi(\theenumii)}
\renewcommand{\p@enumiv}{\p@enumiii\theenumiii}
\newcommand{\labelitemi}{$\m@th\bullet$}
\newcommand{\labelitemii}{\normalfont\bfseries --}
\newcommand{\labelitemiii}{$\m@th\ast$}
\newcommand{\labelitemiv}{$\m@th\cdot$}
\newenvironment{description}
    {\list{}{\labelwidth\z@ \itemindent-\leftmargin
       \itemsep\z@ \let\makelabel\descriptionlabel}}
    {\endlist \unskip}
\newcommand{\descriptionlabel}[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\renewcommand{\itemize}{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \list
      {\csname\@itemitem\endcsname}%
      {\parsep \z@
      \def\makelabel##1{\hss\llap{##1}}}%
  \fi}

\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \begin{center}
        \bfseries \abstractname
      \end{center}}
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item[]}
               {\endlist}
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \if@compatibility
        \setcounter{page}{0}
      \else
        \setcounter{page}{1}%
      \fi}%
    {\if@restonecol\twocolumn \else \newpage \fi
      \setcounter{page}{1}%
    }
\newcommand{\appendix}{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand{\thesection}{\Alph{section}}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand{\theequation}{\arabic{equation}}
\newcounter{figure}
\renewcommand{\thefigure}{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand{\thetable}{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*{\cal}{\@fontswitch{\relax}{\mathcal}}
\DeclareRobustCommand*{\mit}{\@fontswitch{\relax}{\mathnormal}}
\newcommand{\@pnumwidth}{1.55em}
\newcommand{\@tocrmarg} {2.55em}
\newcommand{\@dotsep}{4.5}
\setcounter{tocdepth}{3}
\newcommand{\tableofcontents}{%
    \section*{\contentsname
        \@mkboth{\uppercase{\contentsname}}{\uppercase{\contentsname}}}%
    \@starttoc{toc}%
    }
\newcommand*{\l@part}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{\@secpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hbox to\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}
      \fi
    \endgroup
  \fi}
\newcommand*{\l@section}[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty{\@secpenalty}%
    \addvspace{1.0em \@plus 1pt}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*{\l@subsection}   {\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*{\l@subsubsection}{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*{\l@paragraph}    {\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*{\l@subparagraph} {\@dottedtocline{5}{10em}{5em}}
\newcommand{\listoffigures}{%
    \section*{\listfigurename
      \@mkboth{\uppercase{\listfigurename}}%
              {\uppercase{\listfigurename}}}%
    \@starttoc{lof}%
    }
\newcommand*{\l@figure}{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand{\listoftables}{%
    \section*{\listtablename
      \@mkboth{\uppercase{\listtablename}}{\uppercase{\listtablename}}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\bibindent=0pt
\newdimen\bibfix
\bibfix=10pt
\def\@biblabel#1{#1.}
\newenvironment{thebibliography}[1]
     {\subparagraph*{\refname
        \@mkboth{\uppercase{\refname}}{\uppercase{\refname}}}%
      \list{\@biblabel{\arabic{enumiv}}}%
            {\labelwidth\z@
%           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \if@openbib
              \advance\leftmargin\bibindent
              \itemindent -\bibindent
              \listparindent \itemindent
              \parsep \z@
            \fi
            \itemsep \z@%  Added by FTK
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand{\theenumiv}{\arabic{enumiv}}}%
      \if@openbib
        \renewcommand{\newblock}{\par}
      \else
        \renewcommand{\newblock}{\hskip .11em \@plus.33em \@minus.07em}%
      \fi
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.=\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand{\newblock}{}
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\uppercase{\indexname}}%
                        {\uppercase{\indexname}}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand{\@idxitem}  {\par\hangindent 40\p@}
\newcommand{\subitem}   {\par\hangindent 40\p@ \hspace*{20\p@}}
\newcommand{\subsubitem}{\par\hangindent 40\p@ \hspace*{30\p@}}
\newcommand{\indexspace}{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand{\footnoterule}{%
  \kern-3\p@
  \hrule width .4\columnwidth
  \kern 2.6\p@}
\long\def\@makefntext#1{%
    \parindent 1em%
    \noindent
    \hbox to 1.8em{\hss\@makefnmark}#1}
\newcommand{\contentsname}{Contents}
\newcommand{\listfigurename}{List of Figures}
\newcommand{\listtablename}{List of Tables}
\newcommand{\refname}{References}
\newcommand{\indexname}{Index}
\newcommand{\figurename}{Figure}
\newcommand{\tablename}{Table}
\newcommand{\partname}{Part}
\newcommand{\appendixname}{Appendix}
\newcommand{\abstractname}{Abstract}
\newcommand{\today}{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\ps@plain \pagenumbering{arabic} \onecolumn

% twocolumn.sty  27 Jan 85
% \twocolumn
% \sloppy
% \flushbottom
% \parindent 1em
\leftmargini 1.5em
\leftmarginv .5em
\leftmarginvi .5em
%\oddsidemargin -4pt
\oddsidemargin -12pt
\evensidemargin -26pt
\marginparwidth 48pt
\marginparsep 10pt
\textwidth 425pt

\headheight 12pt \headsep 25pt
\topmargin 0pt
\advance \topmargin by -2\headheight
\advance \topmargin by -\headsep
\footskip 20pt

\textheight 9in

\marginparwidth 0.25in

\textwidth 7in

\columnsep .25in
\parindent \z@
\smallskipamount .5\parskip
\medskipamount \parskip
\bigskipamount 2\parskip
\pagestyle{myheadings}

%%%%%% This may be where special macros start


\def\outtyp{ }% Use j for JPL, a for ACM, leave blank for neither
\if j\outtyp
\def\base_site{JPL}
\else
\def\base_site{Math \`a la Carte}
\fi

%\def\graphtype{metafont}   % The current choice (for .dvi files)
\def\graphtype{pdftex,dvips,metapost}% This choice when using pdflatex

\def\thisyear{\number\year}

\newcommand{\silentfootnote}[1]
   {\gdef\@thefnmark{~}\@footnotetext{#1}}

\def\begmath #1 #2\par {\def\thesection{#1} \def\thesecname{#2}
  \begin{center} \section{#2}\end{center}
  \begin{multicols}{2}}

\def\begcode{\end{multicols} \vspace{-15pt} \ \hrulefill\  \raggedbottom
  \small \baselineskip 9pt \parskip\z@ \parindent=1in}

\def\begcodenp{\end{multicols} \newpage \raggedbottom
  \small \baselineskip 9pt \parskip\z@ \parindent=1in}

\def\begcodenm{\newpage \raggedbottom
  \small \baselineskip 9pt \parskip\z@ \parindent=1in}

\newenvironment{codelist}
     {\advance\@totalleftmargin 1in}{}

\def\begtoc{
  \def\@oddfoot{\rm \small \today \hfil Table of Contents \hfil
      \thepage}
  \def\@evenfoot{\rm \small \thepage \hfil
       Table of Contents \hfil \today}
  \pagenumbering{roman}}

\def\begapp #1 #2\par {{\Large \bf Appendix #1. \quad #2\vspace{5pt}}
  \par \par \small \baselineskip 10pt
  \def\@oddfoot{\rm \small \today \hfil #2 \hfil
      #1--\thepage}
  \def\@evenfoot{\rm \small #1--\thepage \hfil
       #2 \hfil \today}}

\def\begappc #1 #2\par {\def\thesection{Appendix #1.} \def\thesecname{#2}
  \section{#2}
  \def\@oddfoot{\rm \small \today \hfil #2 \hfil
      #1--\thepage}
  \def\@evenfoot{\rm \small #1--\thepage \hfil
       #2 \hfil \today}
  \begin{multicols}{2}}

\def\begcover {\def\@oddfoot{} \def\@evenfoot{}}

\def\begindex {
  \baselineskip 10.85pt
  \def\@oddfoot{\rm \small \today \hfil INDEX--\thepage}
  \def\@evenfoot{\rm \small INDEX--\thepage \hfil \today}}

\def\refm #1{[#1]}
\newcommand{\codeloc}[1]{/math/u/f77/demo/dr#1.f}
\newcommand{\outputloc}[1]{/math/u/f77/output/od#1} 
\newcommand{\extrasloc}[1]{/math/doc/extras/#1}

\def\asinh{\qopname\relax{no}{asinh}}
\def\acosh{\qopname\relax{no}{acosh}}
\def\atanh{\qopname\relax{no}{atanh}}
\def\acsch{\qopname\relax{no}{acsch}}
\def\asech{\qopname\relax{no}{asech}}
\def\actnh{\qopname\relax{no}{actnh}}
\def\erf{\qopname\relax{no}{erf}}
\def\erfc{\qopname\relax{no}{erfc}}
\def\erfce{\qopname\relax{no}{erfce}}
\def\erfi{\qopname\relax{no}{erfi}}
\def\sgn{\qopname\relax{no}{sgn}}
\def\sign{\qopname\relax{no}{sign}}
\def\atan2{\qopname\relax{no}{atan2}}

% Stuff to define needed extra fonts
%
\newcommand{\ninrm}{\fontsize{9}{11}\normalfont\rmfamily}
\newcommand{\fivrm}{\fontsize{5}{6}\normalfont\rmfamily}
%
% some favorite stuff from James Darrell McCauley?
\newcommand{\Cpp}{C{\tt ++}} % C++
\def\PS{{\tt P\small OST\tt S\small CRIPT}}
\def\ATT{{AT{\attand \&}T}}
\def\MF{{METAFONT}}
\def\Cplusplus{{\rm C\raise.5ex\hbox{\small ++}}}
\def\AmSTeX{{$\cal A\kern-.1667em\lower.5ex\hbox{$\cal M$}\kern-.125em
S$-\TeX}}
\def\BibTeX{{\rm B\kern-.05em{\sc i\kern-.025em b}\kern-.08em
    T\kern-.1667em\lower.7ex\hbox{E}\kern-.125emX}}
%
% "narrow" below, thanks to Keith Reckdahl, Stanford Univ.
%-----------------------------------------------------------------
% \begin{narrow}{1.0in}{0.5in}   produces text which is narrowed
%          by 1.0 on left margin and 0.5 inches on right margin
% \begin{narrow}{-1.0in}{-0.5in} produces text which is widened
%          by 1.0 on left margin and 0.5 inches on right margin
% Narrow environments can be nested and are ended by \end{narrow}
%-----------------------------------------------------------------
% \newenvironment{narrow}[2]{%
%  \begin{list}{}{%
%   \setlength{\topsep}{0pt}%
%   \setlength{\leftmargin}{#1}%
%   \setlength{\rightmargin}{#2}%
%   \setlength{\listparindent}{\parindent}%
%   \setlength{\itemindent}{\parindent}%
%   \setlength{\parsep}{\parskip}%
%  }%
% \item[]}{\end{list}}
%
\usepackage{hyperref}
\usepackage{listings}
\lstloadlanguages{Fortran}
\endinput
%%
%% End of file `MATH77.cls'.
