function munu_s_i(p)
%
%  Generates the data used in 'munu_s'. Data are stored in global
%  variables.
%
%  NOTE that 'munu_m_i' must be called before calling this routine.
% 
%  Calling sequence:
%
%    munu_s_i(p)
%
%  Input:
%
%    p         vector containing the ADI shift parameters p(i).
%
%  Remarks:
% 
%    This routine has access to the matrices M and N, which must be 
%    provided by the routine 'munu_m_i'.
%
%    The real parts of the entries of p must be negative.
%
%
%  LYAPACK 1.0 (Thilo Penzl, September 1999)

if nargin~=1
  error('Wrong number of input arguments.');
end

if any(real(p)>=0)
  error('Entries of p must be negative!');
end

l = length(p);

global LP_N LP_M

if ~length(LP_N) | ~length(LP_M) 
  error('This routine needs global data which must be generated by calling ''munu_m_i'' first.');
end 

for i = 1:l

  eval(lp_e( 'global LP_L',i,' LP_U',i ));

  eval(lp_e( '[LP_L',i,', LP_U',i,'] = lu(LP_N+p(i)*LP_M);' ));

end

