function au_s_i(p)
%
%  Generates the data used in 'au_s'. Data are stored in global
%  variables.
% 
%  NOTE that 'au_m_i' must be called before calling this routine.
% 
%  Calling sequence:
%
%    au_s_i(p)
%
%  Input:
%
%    p         vector containing the ADI shift parameters p(i).
%
%  Remarks:
% 
%    This routine has access to the matrix A, which must be provided
%    by the routine 'au_m_i',
%
%    The real parts of the entries of p must be negative.
%
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

if nargin~=1
  error('Wrong number of input arguments.');
end

if any(real(p)>=0)
  error('Real parts of entries of p must be negative!');
end

l = length(p);

global LP_A

if ~length(LP_A)
  error('This routine needs global data which must be generated by calling ''au_m_i'' first.');
end 

I = speye(size(LP_A));

for i = 1:l

  eval(lp_e( 'global LP_L',i,' LP_U',i ));

  eval(lp_e( '[LP_L',i,',LP_U',i,'] = lu(LP_A+p(',i,')*I);' ));

end

