function Y = au_l(tr,X)
%
%  Solves linear systems with the real matrix A or its transposed A':
%
%  for tr = 'N':
%
%    Y = inv(A)*X,
%
%  for tr = 'T':
%
%    Y = inv(A')*X.
%
%  The LU factors of A are provided as global data. This data must 
%  be generated by calling 'au_l_i' before calling this routine!
%
%  Calling sequence:
%
%    Y = au_l(tr,X)
%
%  Input:
%
%    tr        (= 'N' or 'T') determines whether systems with A or A' 
%              should be solved;
%    X         matrix of proper size.
%
%  Output:
%
%    Y         the solution matrix. 
%
% 
%   LYAPACK 1.0 (Thilo Penzl, May 1999)

if nargin~=2
  error('Wrong number of input arguments.');
end

global LP_L LP_U

if ~length(LP_L) | ~length(LP_U)
  error('This routine needs global data which must be generated by calling ''au_l_i'' first.');
end 

if tr=='N'
  Y = LP_U\(LP_L\X);
elseif tr=='T'
  Y = LP_L'\(LP_U'\X);
else
  error('tp must be either ''N'' or ''T''.');
end
