function nrm_G = lp_gnorm(Gs,m,q)
%
%  Given the transfer function sample matrix Gs, which contains 
%  sampled values of the transfer function G(s) at the 'frequency 
%  sampling points' sqrt(-1)*freq(:), this routine computes the
%  2-norm (i.e., the maximal singular value) of G(:) for each sampling
%  point. That means, the result is 
%
%    nrm_G(i) = sigma_max ( G( sqrt(-1) * freq(i) ) ).
%
%  See also function 'lp_trfia', which generates transfer function sample
%  matrices.
%
%  Calling sequence:
%
%    nrm_G = lp_gnorm(Gs,m,q)
%
%  Input:
%
%    Gs         transfer function sample matrix; 
%    m          number of input variables of the systems;
%    q          number of output variables of the systems.
%
%  Output:
%
%    nrm_G      Vector containing the 'sampled' 2-norms of G(s) for
%               the frequency points, which were used to generate Gs.
% 
%  Remarks:     
%
%    If the norms of the difference of two systems G1(s)-G2(s) is of 
%    interest, call 
%
%      nrm_G = lp_gnorm(G1s-G2s,m,q).
%
%    Of course, both G1s and G2s must refer to the same frequency vector
%    freq (i.e., the same vector freq must be used when these matrices
%    are generated by calling the function 'lp_trfia' twice.).
%   
%
%   LYAPACK 1.0 (Thilo Penzl, May 1999)

% Input data not completely checked!

[r,nop] = size(Gs);

if r~=m*q, error('Number of rows in G is not equal to m*q.'); end

nrm_G = zeros(1,nop);

g = zeros(q,m);

for i = 1:nop 

  for j = 1:m
    g(:,j) = Gs((j-1)*q+1:j*q,i);    
  end

  nrm_G(i) = norm(g);

end




